package drr.regulation.common.trade.basket.reports;

import cdm.base.math.CapacityUnitEnum;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.WeatherUnitEnum;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.template.BasketConstituent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.standards.iso.functions.CapacityUnitToISO20022UnitOfMeasure;
import drr.standards.iso.functions.FinancialUnitToISO20022UnitOfMeasure;
import drr.standards.iso.functions.WeatherUnitToISO20022UnitOfMeasure;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(BasketConstituentUnitOfMeasureRule.BasketConstituentUnitOfMeasureRuleDefault.class)
public abstract class BasketConstituentUnitOfMeasureRule implements ReportFunction<BasketConstituent, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CapacityUnitToISO20022UnitOfMeasure capacityUnitToISO20022UnitOfMeasure;
	@Inject protected FinancialUnitToISO20022UnitOfMeasure financialUnitToISO20022UnitOfMeasure;
	@Inject protected WeatherUnitToISO20022UnitOfMeasure weatherUnitToISO20022UnitOfMeasure;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(BasketConstituent input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(BasketConstituent input);

	public static class BasketConstituentUnitOfMeasureRuleDefault extends BasketConstituentUnitOfMeasureRule {
		@Override
		protected String doEvaluate(BasketConstituent input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, BasketConstituent input) {
			final MapperS<UnitType> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> {
					final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule = item.<ReferenceWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", basketConstituent -> basketConstituent.getQuantity()).get();
					return (referenceWithMetaNonNegativeQuantitySchedule == null ? MapperS.<NonNegativeQuantitySchedule>ofNull() : MapperS.of(referenceWithMetaNonNegativeQuantitySchedule.getValue())).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit());
				});
			output = thenArg
				.mapSingleToItem(item -> {
					if (exists(item.<CapacityUnitEnum>map("getCapacityUnit", unitType -> unitType.getCapacityUnit())).getOrDefault(false)) {
						return MapperS.of(capacityUnitToISO20022UnitOfMeasure.evaluate(item.<CapacityUnitEnum>map("getCapacityUnit", unitType -> unitType.getCapacityUnit()).get()));
					}
					if (exists(item.<WeatherUnitEnum>map("getWeatherUnit", unitType -> unitType.getWeatherUnit())).getOrDefault(false)) {
						return MapperS.of(weatherUnitToISO20022UnitOfMeasure.evaluate(item.<WeatherUnitEnum>map("getWeatherUnit", unitType -> unitType.getWeatherUnit()).get()));
					}
					if (exists(item.<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(false)) {
						return MapperS.of(financialUnitToISO20022UnitOfMeasure.evaluate(item.<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit()).get()));
					}
					return MapperS.<String>ofNull();
				}).get();
			
			return output;
		}
	}
}
