package drr.regulation.common.trade.execution.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.MandatorilyClearableEnum;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsRegulatedMarketOrThirdCountryEquivalentMarket;
import drr.regulation.common.metafields.FieldWithMetaRegimeNameEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import drr.standards.iso.ClearingObligationEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ClearingObligation.ClearingObligationDefault.class)
public abstract class ClearingObligation implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsRegulatedMarketOrThirdCountryEquivalentMarket isRegulatedMarketOrThirdCountryEquivalentMarket;

	/**
	* @param transactionReportInstruction 
	* @param rgmName 
	* @param sprvsryBody 
	* @return result 
	*/
	public ClearingObligationEnum evaluate(TransactionReportInstruction transactionReportInstruction, RegimeNameEnum rgmName, SupervisoryBodyEnum sprvsryBody) {
		ClearingObligationEnum result = doEvaluate(transactionReportInstruction, rgmName, sprvsryBody);
		
		return result;
	}

	protected abstract ClearingObligationEnum doEvaluate(TransactionReportInstruction transactionReportInstruction, RegimeNameEnum rgmName, SupervisoryBodyEnum sprvsryBody);

	public static class ClearingObligationDefault extends ClearingObligation {
		@Override
		protected ClearingObligationEnum doEvaluate(TransactionReportInstruction transactionReportInstruction, RegimeNameEnum rgmName, SupervisoryBodyEnum sprvsryBody) {
			ClearingObligationEnum result = null;
			return assignOutput(result, transactionReportInstruction, rgmName, sprvsryBody);
		}
		
		protected ClearingObligationEnum assignOutput(ClearingObligationEnum result, TransactionReportInstruction transactionReportInstruction, RegimeNameEnum rgmName, SupervisoryBodyEnum sprvsryBody) {
			if (areEqual(MapperS.of(isRegulatedMarketOrThirdCountryEquivalentMarket.evaluate(MapperS.of(transactionReportInstruction).<ReportableInformation>map("getReportableInformation", _transactionReportInstruction -> _transactionReportInstruction.getReportableInformation()).get(), rgmName)), MapperS.of(false), CardinalityOperator.All).getOrDefault(false)) {
				final MapperC<ReportingRegime> thenArg0 = MapperS.of(transactionReportInstruction).<ReportableInformation>map("getReportableInformation", _transactionReportInstruction -> _transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation());
				final MapperC<ReportingRegime> thenArg1 = thenArg0
					.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(sprvsryBody), CardinalityOperator.All).and(areEqual(item.<FieldWithMetaRegimeNameEnum>map("getRegimeName", reportingRegime -> reportingRegime.getRegimeName()).<RegimeNameEnum>map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), MapperS.of(rgmName), CardinalityOperator.All)).get());
				final MapperS<ReportingRegime> thenArg2 = thenArg1
					.last();
				result = thenArg2
					.mapSingleToItem(item -> {
						if (areEqual(item.<MandatorilyClearableEnum>map("getMandatorilyClearable", reportingRegime -> reportingRegime.getMandatorilyClearable()), MapperS.of(MandatorilyClearableEnum.PRODUCT_AND_CPTY_MANDATORY), CardinalityOperator.All).getOrDefault(false)) {
							return MapperS.of(ClearingObligationEnum.TRUE);
						}
						if (areEqual(item.<MandatorilyClearableEnum>map("getMandatorilyClearable", reportingRegime -> reportingRegime.getMandatorilyClearable()), MapperS.of(MandatorilyClearableEnum.PRODUCT_MANDATORY_BUT_NOT_CPTY), CardinalityOperator.All).getOrDefault(false)) {
							return MapperS.of(ClearingObligationEnum.FLSE);
						}
						if (areEqual(item.<MandatorilyClearableEnum>map("getMandatorilyClearable", reportingRegime -> reportingRegime.getMandatorilyClearable()), MapperS.of(MandatorilyClearableEnum.PRODUCT_NOT_MANDATORY), CardinalityOperator.All).getOrDefault(false)) {
							return MapperS.of(ClearingObligationEnum.UKWN);
						}
						return MapperS.<ClearingObligationEnum>ofNull();
					}).get();
			} else {
				result = null;
			}
			
			return result;
		}
	}
}
