package drr.regulation.common.trade.link.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.metafields.FieldWithMetaRegimeNameEnum;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(TechnicalRecordId.TechnicalRecordIdDefault.class)
public abstract class TechnicalRecordId implements RosettaFunction {

	/**
	* @param reportableInformation 
	* @param regime 
	* @return technicalRecordIdentifier 
	*/
	public String evaluate(ReportableInformation reportableInformation, RegimeNameEnum regime) {
		String technicalRecordIdentifier = doEvaluate(reportableInformation, regime);
		
		return technicalRecordIdentifier;
	}

	protected abstract String doEvaluate(ReportableInformation reportableInformation, RegimeNameEnum regime);

	public static class TechnicalRecordIdDefault extends TechnicalRecordId {
		@Override
		protected String doEvaluate(ReportableInformation reportableInformation, RegimeNameEnum regime) {
			String technicalRecordIdentifier = null;
			return assignOutput(technicalRecordIdentifier, reportableInformation, regime);
		}
		
		protected String assignOutput(String technicalRecordIdentifier, ReportableInformation reportableInformation, RegimeNameEnum regime) {
			final MapperC<ReportingRegime> thenArg0 = MapperS.of(reportableInformation).<PartyInformation>mapC("getPartyInformation", _reportableInformation -> _reportableInformation.getPartyInformation()).<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation());
			final MapperC<ReportingRegime> thenArg1 = thenArg0
				.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaRegimeNameEnum>map("getRegimeName", reportingRegime -> reportingRegime.getRegimeName()).<RegimeNameEnum>map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), MapperS.of(regime), CardinalityOperator.All).get());
			final MapperC<FieldWithMetaString> thenArg2 = thenArg1
				.mapItem(item -> item.<FieldWithMetaString>map("getTechnicalRecordId", reportingRegime -> reportingRegime.getTechnicalRecordId()));
			final FieldWithMetaString fieldWithMetaString = MapperS.of(distinct(thenArg2).get()).get();
			if (fieldWithMetaString == null) {
				technicalRecordIdentifier = null;
			} else {
				technicalRecordIdentifier = fieldWithMetaString.getValue();
			}
			
			return technicalRecordIdentifier;
		}
	}
}
