package drr.regulation.common.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.valuation.meta.CommonValuationReportMeta;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Common Valuation Report represents common attributes for the Valuation report
 * @version 7.0.0-dev.17
 */
@RosettaDataType(value="CommonValuationReport", builder=CommonValuationReport.CommonValuationReportBuilderImpl.class, version="7.0.0-dev.17")
@RuneDataType(value="CommonValuationReport", model="drr", builder=CommonValuationReport.CommonValuationReportBuilderImpl.class, version="7.0.0-dev.17")
public interface CommonValuationReport extends CriticalDataElement {

	CommonValuationReportMeta metaData = new CommonValuationReportMeta();

	/*********************** Getter Methods  ***********************/
	String getReportSubmittingEntityID();
	String getEntityResponsibleForReporting();
	String getUti();
	Date getEventDate();

	/*********************** Build Methods  ***********************/
	CommonValuationReport build();
	
	CommonValuationReport.CommonValuationReportBuilder toBuilder();
	
	static CommonValuationReport.CommonValuationReportBuilder builder() {
		return new CommonValuationReport.CommonValuationReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CommonValuationReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CommonValuationReport> getType() {
		return CommonValuationReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
		processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
		processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
		processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
		processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
		processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, getLevel(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
		processor.processBasic(path.newSubPath("uti"), String.class, getUti(), this);
		processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CommonValuationReportBuilder extends CommonValuationReport, CriticalDataElement.CriticalDataElementBuilder {
		@Override
		CommonValuationReport.CommonValuationReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		@Override
		CommonValuationReport.CommonValuationReportBuilder setCounterparty1(String counterparty1);
		@Override
		CommonValuationReport.CommonValuationReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		@Override
		CommonValuationReport.CommonValuationReportBuilder setCounterparty2(String counterparty2);
		@Override
		CommonValuationReport.CommonValuationReportBuilder setValuationAmount(BigDecimal valuationAmount);
		@Override
		CommonValuationReport.CommonValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum valuationCurrency);
		@Override
		CommonValuationReport.CommonValuationReportBuilder setValuationTimestamp(ZonedDateTime valuationTimestamp);
		@Override
		CommonValuationReport.CommonValuationReportBuilder setValuationMethod(ValuationType1Code valuationMethod);
		@Override
		CommonValuationReport.CommonValuationReportBuilder setDelta(BigDecimal delta);
		@Override
		CommonValuationReport.CommonValuationReportBuilder setActionType(ActionTypeEnum actionType);
		@Override
		CommonValuationReport.CommonValuationReportBuilder setLevel(ReportLevelEnum level);
		CommonValuationReport.CommonValuationReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		CommonValuationReport.CommonValuationReportBuilder setEntityResponsibleForReporting(String entityResponsibleForReporting);
		CommonValuationReport.CommonValuationReportBuilder setUti(String uti);
		CommonValuationReport.CommonValuationReportBuilder setEventDate(Date eventDate);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
			processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
			processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
			processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
			processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
			processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, getLevel(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
			processor.processBasic(path.newSubPath("uti"), String.class, getUti(), this);
			processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
		}
		

		CommonValuationReport.CommonValuationReportBuilder prune();
	}

	/*********************** Immutable Implementation of CommonValuationReport  ***********************/
	class CommonValuationReportImpl extends CriticalDataElement.CriticalDataElementImpl implements CommonValuationReport {
		private final String reportSubmittingEntityID;
		private final String entityResponsibleForReporting;
		private final String uti;
		private final Date eventDate;
		
		protected CommonValuationReportImpl(CommonValuationReport.CommonValuationReportBuilder builder) {
			super(builder);
			this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
			this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
			this.uti = builder.getUti();
			this.eventDate = builder.getEventDate();
		}
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute(value="uti", isRequired=true)
		@RuneAttribute(value="uti", isRequired=true)
		public String getUti() {
			return uti;
		}
		
		@Override
		@RosettaAttribute("eventDate")
		@RuneAttribute("eventDate")
		public Date getEventDate() {
			return eventDate;
		}
		
		@Override
		public CommonValuationReport build() {
			return this;
		}
		
		@Override
		public CommonValuationReport.CommonValuationReportBuilder toBuilder() {
			CommonValuationReport.CommonValuationReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CommonValuationReport.CommonValuationReportBuilder builder) {
			super.setBuilderFields(builder);
			ofNullable(getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityID);
			ofNullable(getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
			ofNullable(getUti()).ifPresent(builder::setUti);
			ofNullable(getEventDate()).ifPresent(builder::setEventDate);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			CommonValuationReport _that = getType().cast(o);
		
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(uti, _that.getUti())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (uti != null ? uti.hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonValuationReport {" +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"uti=" + this.uti + ", " +
				"eventDate=" + this.eventDate +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of CommonValuationReport  ***********************/
	class CommonValuationReportBuilderImpl extends CriticalDataElement.CriticalDataElementBuilderImpl implements CommonValuationReport.CommonValuationReportBuilder {
	
		protected String reportSubmittingEntityID;
		protected String entityResponsibleForReporting;
		protected String uti;
		protected Date eventDate;
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute(value="uti", isRequired=true)
		@RuneAttribute(value="uti", isRequired=true)
		public String getUti() {
			return uti;
		}
		
		@Override
		@RosettaAttribute("eventDate")
		@RuneAttribute("eventDate")
		public Date getEventDate() {
			return eventDate;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute(value="valuationAmount", isRequired=true)
		@RuneAttribute(value="valuationAmount", isRequired=true)
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
			this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
			return this;
		}
		
		@RosettaAttribute(value="valuationCurrency", isRequired=true)
		@RuneAttribute(value="valuationCurrency", isRequired=true)
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
			this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
			return this;
		}
		
		@RosettaAttribute(value="valuationTimestamp", isRequired=true)
		@RuneAttribute(value="valuationTimestamp", isRequired=true)
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
			this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="valuationMethod", isRequired=true)
		@RuneAttribute(value="valuationMethod", isRequired=true)
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
			this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
			return this;
		}
		
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setDelta(BigDecimal _delta) {
			this.delta = _delta == null ? null : _delta;
			return this;
		}
		
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setActionType(ActionTypeEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute(value="level", isRequired=true)
		@RuneAttribute(value="level", isRequired=true)
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setLevel(ReportLevelEnum _level) {
			this.level = _level == null ? null : _level;
			return this;
		}
		
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
			this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
			return this;
		}
		
		@RosettaAttribute(value="uti", isRequired=true)
		@RuneAttribute(value="uti", isRequired=true)
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setUti(String _uti) {
			this.uti = _uti == null ? null : _uti;
			return this;
		}
		
		@RosettaAttribute("eventDate")
		@RuneAttribute("eventDate")
		@Override
		public CommonValuationReport.CommonValuationReportBuilder setEventDate(Date _eventDate) {
			this.eventDate = _eventDate == null ? null : _eventDate;
			return this;
		}
		
		@Override
		public CommonValuationReport build() {
			return new CommonValuationReport.CommonValuationReportImpl(this);
		}
		
		@Override
		public CommonValuationReport.CommonValuationReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonValuationReport.CommonValuationReportBuilder prune() {
			super.prune();
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getReportSubmittingEntityID()!=null) return true;
			if (getEntityResponsibleForReporting()!=null) return true;
			if (getUti()!=null) return true;
			if (getEventDate()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonValuationReport.CommonValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			CommonValuationReport.CommonValuationReportBuilder o = (CommonValuationReport.CommonValuationReportBuilder) other;
			
			
			merger.mergeBasic(getReportSubmittingEntityID(), o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID);
			merger.mergeBasic(getEntityResponsibleForReporting(), o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting);
			merger.mergeBasic(getUti(), o.getUti(), this::setUti);
			merger.mergeBasic(getEventDate(), o.getEventDate(), this::setEventDate);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			CommonValuationReport _that = getType().cast(o);
		
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(uti, _that.getUti())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (uti != null ? uti.hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonValuationReportBuilder {" +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"uti=" + this.uti + ", " +
				"eventDate=" + this.eventDate +
			'}' + " " + super.toString();
		}
	}
}
