package drr.regulation.common.valuation.datetime.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ValuationReportInstruction;
import drr.regulation.common.functions.ExtractDateFromDateTime;
import javax.inject.Inject;


@ImplementedBy(EventDateRule.EventDateRuleDefault.class)
public abstract class EventDateRule implements ReportFunction<ValuationReportInstruction, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractDateFromDateTime extractDateFromDateTime;
	@Inject protected ValuationTimestampRule valuationTimestampRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(ValuationReportInstruction input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(ValuationReportInstruction input);

	public static class EventDateRuleDefault extends EventDateRule {
		@Override
		protected Date doEvaluate(ValuationReportInstruction input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, ValuationReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(extractDateFromDateTime.evaluate(valuationTimestampRule.evaluate(item.get())))).get();
			
			return output;
		}
	}
}
