package drr.regulation.csa.rewrite.dtcc.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.CreditIndexReferenceInformation;
import cdm.product.asset.GeneralTerms;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetAllUnderlierProductIdentifier;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.common.metafields.FieldWithMetaRegimeNameEnum;
import drr.regulation.csa.rewrite.dtcc.UnderlyingAssetNameReport;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(DTCC_UnderlyingAssetNameRule.DTCC_UnderlyingAssetNameRuleDefault.class)
public abstract class DTCC_UnderlyingAssetNameRule implements ReportFunction<TransactionReportInstruction, UnderlyingAssetNameReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected GetAllUnderlierProductIdentifier getAllUnderlierProductIdentifier;
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;
	@Inject protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public UnderlyingAssetNameReport evaluate(TransactionReportInstruction input) {
		UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder outputBuilder = doEvaluate(input);
		
		final UnderlyingAssetNameReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(UnderlyingAssetNameReport.class, output);
		}
		
		return output;
	}

	protected abstract UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class DTCC_UnderlyingAssetNameRuleDefault extends DTCC_UnderlyingAssetNameRule {
		@Override
		protected UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder doEvaluate(TransactionReportInstruction input) {
			UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder output = UnderlyingAssetNameReport.builder();
			return assignOutput(output, input);
		}
		
		protected UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder assignOutput(UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					if (areEqual(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<FieldWithMetaRegimeNameEnum>map("getRegimeName", reportingRegime -> reportingRegime.getRegimeName()).<RegimeNameEnum>map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum.getValue()), MapperS.of(RegimeNameEnum.CSA), CardinalityOperator.Any).and(greaterThan(MapperS.of(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).resultCount()), MapperS.of(1), CardinalityOperator.All)).getOrDefault(false)) {
						return MapperS.of(productForEvent.evaluate(item.get()));
					}
					return MapperS.<Product>ofNull();
				});
			final MapperS<Product> thenArg2 = thenArg1
				.filterSingleNullSafe(item -> qualify_AssetClass_Credit.evaluate(economicTermsForProduct.evaluate(item.get())));
			final MapperS<Product> thenArg3 = thenArg2
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			output = toBuilder(thenArg3
				.mapSingleToItem(item -> {
					if (exists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation())).getOrDefault(false)) {
						return MapperS.of(UnderlyingAssetNameReport.builder()
							.setUnderlyingAssetName(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName()).<String>map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()).getMulti())
							.build());
					}
					if (exists(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation())).getOrDefault(false)) {
						return MapperS.of(UnderlyingAssetNameReport.builder()
							.setUnderlyingAssetName(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName()).<String>map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()).getMulti())
							.build());
					}
					if (exists(MapperC.<ProductIdentifier>of(getAllUnderlierProductIdentifier.evaluate(item.get()))).getOrDefault(false)) {
						final MapperC<ProductIdentifier> _thenArg0 = MapperC.<ProductIdentifier>of(getAllUnderlierProductIdentifier.evaluate(item.get()));
						final MapperC<ProductIdentifier> _thenArg1 = _thenArg0
							.filterItemNullSafe(_item -> areEqual(_item.<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.All).get());
						return MapperS.of(UnderlyingAssetNameReport.builder()
							.setUnderlyingAssetName(_thenArg1.<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti())
							.build());
					}
					return MapperS.<UnderlyingAssetNameReport>ofNull();
				}).get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
