package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.datetime.reports.FixingDateLeg1Rule;
import drr.regulation.common.trade.datetime.reports.FixingDateLeg2Rule;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodLeg1Rule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodLeg2Rule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodMultiplierLeg1Rule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodMultiplierLeg2Rule;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg1;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg2;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg1Rule;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg2Rule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg1CommodityInstrumentIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg1CommodityUnderlyerIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg1FloatingRateIndexRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg2CommodityInstrumentIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg2CommodityUnderlyerIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg2FloatingRateIndexRule;
import drr.regulation.csa.rewrite.functions.CSALegEnrichment;
import drr.regulation.csa.rewrite.trade.CSALeg;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg2Aligned;
import drr.standards.iosco.cde.version3.functions.Leg1;
import drr.standards.iosco.cde.version3.functions.Leg2;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleLeg1Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleLeg2Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleLeg1Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleLeg2Rule;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Leg2ReportPPDRule.Leg2ReportPPDRuleDefault.class)
public abstract class Leg2ReportPPDRule implements ReportFunction<TransactionReportInstruction, CSALeg> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CSALegEnrichment cSALegEnrichment;
	@Inject protected DTCC_Leg1CommodityInstrumentIDRule dTCC_Leg1CommodityInstrumentIDRule;
	@Inject protected DTCC_Leg1CommodityUnderlyerIDRule dTCC_Leg1CommodityUnderlyerIDRule;
	@Inject protected DTCC_Leg1FloatingRateIndexRule dTCC_Leg1FloatingRateIndexRule;
	@Inject protected DTCC_Leg2CommodityInstrumentIDRule dTCC_Leg2CommodityInstrumentIDRule;
	@Inject protected DTCC_Leg2CommodityUnderlyerIDRule dTCC_Leg2CommodityUnderlyerIDRule;
	@Inject protected DTCC_Leg2FloatingRateIndexRule dTCC_Leg2FloatingRateIndexRule;
	@Inject protected FixingDateLeg1Rule fixingDateLeg1Rule;
	@Inject protected FixingDateLeg2Rule fixingDateLeg2Rule;
	@Inject protected FloatingRateResetFrequencyPeriodLeg1Rule floatingRateResetFrequencyPeriodLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodLeg2Rule floatingRateResetFrequencyPeriodLeg2Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierLeg1Rule floatingRateResetFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierLeg2Rule floatingRateResetFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsCSALeg2Aligned isCSALeg2Aligned;
	@Inject protected Leg1 leg1;
	@Inject protected Leg2 leg2;
	@Inject protected LegEnrichment legEnrichment;
	@Inject protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
	@Inject protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
	@Inject protected NotionalQuantityLeg1Rule notionalQuantityLeg1Rule;
	@Inject protected NotionalQuantityLeg2Rule notionalQuantityLeg2Rule;
	@Inject protected NotionalQuantityScheduleLeg1Rule notionalQuantityScheduleLeg1Rule;
	@Inject protected NotionalQuantityScheduleLeg2Rule notionalQuantityScheduleLeg2Rule;
	@Inject protected QuantityFrequencyLeg1 quantityFrequencyLeg1;
	@Inject protected QuantityFrequencyLeg2 quantityFrequencyLeg2;
	@Inject protected QuantityUnitOfMeasureLeg2Rule quantityUnitOfMeasureLeg2Rule;
	@Inject protected SpreadNotationLeg2Rule spreadNotationLeg2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CSALeg evaluate(TransactionReportInstruction input) {
		CSALeg.CSALegBuilder outputBuilder = doEvaluate(input);
		
		final CSALeg output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CSALeg.class, output);
		}
		
		return output;
	}

	protected abstract CSALeg.CSALegBuilder doEvaluate(TransactionReportInstruction input);

	public static class Leg2ReportPPDRuleDefault extends Leg2ReportPPDRule {
		@Override
		protected CSALeg.CSALegBuilder doEvaluate(TransactionReportInstruction input) {
			CSALeg.CSALegBuilder output = CSALeg.builder();
			return assignOutput(output, input);
		}
		
		protected CSALeg.CSALegBuilder assignOutput(CSALeg.CSALegBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			final Boolean _boolean = isCSALeg2Aligned.evaluate(thenArg.get());
			final MapperS<CSALeg> ifThenElseResult;
			if ((_boolean == null ? false : _boolean)) {
				ifThenElseResult = MapperS.of(cSALegEnrichment.evaluate(legEnrichment.evaluate(leg2.evaluate(thenArg.get(), spreadNotationLeg2Rule.evaluate(thenArg.get()), new BigDecimal("99999999999999999999.99999")), notionalAmountScheduleLeg2Rule.evaluate(thenArg.get()), notionalQuantityScheduleLeg2Rule.evaluate(thenArg.get()), notionalQuantityLeg2Rule.evaluate(thenArg.get()), floatingRateResetFrequencyPeriodLeg2Rule.evaluate(thenArg.get()), floatingRateResetFrequencyPeriodMultiplierLeg2Rule.evaluate(thenArg.get()), fixingDateLeg2Rule.evaluate(thenArg.get()), MapperS.of(quantityFrequencyLeg2.evaluate(thenArg.get())).<FrequencyPeriodEnum>map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod()).get(), MapperS.of(quantityFrequencyLeg2.evaluate(thenArg.get())).<Integer>map("getPeriodMultiplier", quantityFrequency -> quantityFrequency.getPeriodMultiplier()).get(), null, null, null, null, null), quantityUnitOfMeasureLeg2Rule.evaluate(thenArg.get()), null, null, null, null, null, null, null, null, dTCC_Leg2CommodityUnderlyerIDRule.evaluate(thenArg.get()), dTCC_Leg2CommodityInstrumentIDRule.evaluate(thenArg.get()), dTCC_Leg2FloatingRateIndexRule.evaluate(thenArg.get())));
			} else {
				ifThenElseResult = MapperS.of(cSALegEnrichment.evaluate(legEnrichment.evaluate(leg1.evaluate(thenArg.get(), spreadNotationLeg2Rule.evaluate(thenArg.get()), new BigDecimal("99999999999999999999.99999")), notionalAmountScheduleLeg1Rule.evaluate(thenArg.get()), notionalQuantityScheduleLeg1Rule.evaluate(thenArg.get()), notionalQuantityLeg1Rule.evaluate(thenArg.get()), floatingRateResetFrequencyPeriodLeg1Rule.evaluate(thenArg.get()), floatingRateResetFrequencyPeriodMultiplierLeg1Rule.evaluate(thenArg.get()), fixingDateLeg1Rule.evaluate(thenArg.get()), MapperS.of(quantityFrequencyLeg1.evaluate(thenArg.get())).<FrequencyPeriodEnum>map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod()).get(), MapperS.of(quantityFrequencyLeg1.evaluate(thenArg.get())).<Integer>map("getPeriodMultiplier", quantityFrequency -> quantityFrequency.getPeriodMultiplier()).get(), null, null, null, null, null), quantityUnitOfMeasureLeg2Rule.evaluate(thenArg.get()), null, null, null, null, null, null, null, null, dTCC_Leg1CommodityUnderlyerIDRule.evaluate(thenArg.get()), dTCC_Leg1CommodityInstrumentIDRule.evaluate(thenArg.get()), dTCC_Leg1FloatingRateIndexRule.evaluate(thenArg.get())));
			}
			output = toBuilder(ifThenElseResult.get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
