package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ExecutionVenueTypeEnum;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.SupervisoryBodyForCSA;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PlatformAnonymousExecutionIndicatorRule.PlatformAnonymousExecutionIndicatorRuleDefault.class)
public abstract class PlatformAnonymousExecutionIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected SupervisoryBodyForCSA supervisoryBodyForCSA;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class PlatformAnonymousExecutionIndicatorRuleDefault extends PlatformAnonymousExecutionIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			final MapperS<ReportableInformation> thenArg1 = thenArg0
				.mapSingleToItem(item -> item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()));
			output = thenArg1
				.mapSingleToItem(item -> {
					final MapperC<PartyInformation> thenArg = item.<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation())
						.filterItemNullSafe(_item -> areEqual(MapperC.<SupervisoryBodyEnum>of(supervisoryBodyForCSA.evaluate()), _item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()), CardinalityOperator.Any).get());
					if (ComparisonResult.of(exists(thenArg).asMapper()).and(areEqual(item.<ExecutionVenueTypeEnum>map("getExecutionVenueType", reportableInformation -> reportableInformation.getExecutionVenueType()), MapperS.of(ExecutionVenueTypeEnum.SEF), CardinalityOperator.All).or(areEqual(item.<ExecutionVenueTypeEnum>map("getExecutionVenueType", reportableInformation -> reportableInformation.getExecutionVenueType()), MapperS.of(ExecutionVenueTypeEnum.DCM), CardinalityOperator.All))).getOrDefault(false)) {
						if (exists(item.<Boolean>map("getSefOrDcmAnonymousIndicator", reportableInformation -> reportableInformation.getSefOrDcmAnonymousIndicator())).getOrDefault(false)) {
							return item.<Boolean>map("getSefOrDcmAnonymousIndicator", reportableInformation -> reportableInformation.getSefOrDcmAnonymousIndicator());
						}
						return MapperS.of(false);
					}
					return MapperS.<Boolean>ofNull();
				}).get();
			
			return output;
		}
	}
}
