package drr.regulation.csa.rewrite.valuation.validation.exists;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.csa.rewrite.valuation.CSAValuationReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class CSAValuationReportOnlyExistsValidator implements ValidatorWithArg<CSAValuationReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends CSAValuationReport> ValidationResult<CSAValuationReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("counterparty1", ExistenceChecker.isSet((String) o.getCounterparty1()))
				.put("counterparty2", ExistenceChecker.isSet((String) o.getCounterparty2()))
				.put("counterparty2IdentifierSource", ExistenceChecker.isSet((String) o.getCounterparty2IdentifierSource()))
				.put("reportingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getReportingTimestamp()))
				.put("uniqueTransactionIdentifier", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifier()))
				.put("submitterIdentifier", ExistenceChecker.isSet((String) o.getSubmitterIdentifier()))
				.put("variationMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getVariationMarginCollateralPortfolioCode()))
				.put("initialMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getInitialMarginCollateralPortfolioCode()))
				.put("actionType", ExistenceChecker.isSet((ActionTypeEnum) o.getActionType()))
				.put("valuationAmount", ExistenceChecker.isSet((BigDecimal) o.getValuationAmount()))
				.put("valuationCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getValuationCurrency()))
				.put("valuationMethod", ExistenceChecker.isSet((ValuationType1Code) o.getValuationMethod()))
				.put("valuationTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getValuationTimestamp()))
				.put("nextFloatingReferenceResetDateLeg1", ExistenceChecker.isSet((Date) o.getNextFloatingReferenceResetDateLeg1()))
				.put("nextFloatingReferenceResetDateLeg2", ExistenceChecker.isSet((Date) o.getNextFloatingReferenceResetDateLeg2()))
				.put("lastFloatingReferenceValueLeg1", ExistenceChecker.isSet((BigDecimal) o.getLastFloatingReferenceValueLeg1()))
				.put("lastFloatingReferenceValueLeg2", ExistenceChecker.isSet((BigDecimal) o.getLastFloatingReferenceValueLeg2()))
				.put("lastFloatingReferenceResetDateLeg1", ExistenceChecker.isSet((Date) o.getLastFloatingReferenceResetDateLeg1()))
				.put("lastFloatingReferenceResetDateLeg2", ExistenceChecker.isSet((Date) o.getLastFloatingReferenceResetDateLeg2()))
				.put("delta", ExistenceChecker.isSet((BigDecimal) o.getDelta()))
				.put("uniqueProductIdentifier", ExistenceChecker.isSet((String) o.getUniqueProductIdentifier()))
				.put("tradeParty1IDType", ExistenceChecker.isSet((PartyIdentifierTypeEnum) o.getTradeParty1IDType()))
				.put("submittingPartyIDType", ExistenceChecker.isSet((PartyIdentifierTypeEnum) o.getSubmittingPartyIDType()))
				.put("usiID", ExistenceChecker.isSet((String) o.getUsiID()))
				.put("usiIDPrefix", ExistenceChecker.isSet((String) o.getUsiIDPrefix()))
				.put("submittedForParty", ExistenceChecker.isSet((String) o.getSubmittedForParty()))
				.put("tradeParty1ReportingDestination", ExistenceChecker.isSet((List<SupervisoryBodyEnum>) o.getTradeParty1ReportingDestination()))
				.put("tradeParty2ReportingDestination", ExistenceChecker.isSet((List<SupervisoryBodyEnum>) o.getTradeParty2ReportingDestination()))
				.put("primaryAssetClass", ExistenceChecker.isSet((AssetClassEnum) o.getPrimaryAssetClass()))
				.put("comment1", ExistenceChecker.isSet((String) o.getComment1()))
				.put("messageID", ExistenceChecker.isSet((String) o.getMessageID()))
				.put("messageType", ExistenceChecker.isSet((String) o.getMessageType()))
				.put("tradeParty2ExecutionAgentID", ExistenceChecker.isSet((String) o.getTradeParty2ExecutionAgentID()))
				.put("tradeParty2ExecutionAgentIDType", ExistenceChecker.isSet((PartyIdentifierTypeEnum) o.getTradeParty2ExecutionAgentIDType()))
				.put("tradeParty1ExecutionAgentID", ExistenceChecker.isSet((String) o.getTradeParty1ExecutionAgentID()))
				.put("tradeParty1ExecutionAgentIDType", ExistenceChecker.isSet((PartyIdentifierTypeEnum) o.getTradeParty1ExecutionAgentIDType()))
				.put("tradeParty1TransactionID", ExistenceChecker.isSet((String) o.getTradeParty1TransactionID()))
				.put("version", ExistenceChecker.isSet((String) o.getVersion()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("CSAValuationReport", ValidationResult.ValidationType.ONLY_EXISTS, "CSAValuationReport", path, "");
		}
		return failure("CSAValuationReport", ValidationResult.ValidationType.ONLY_EXISTS, "CSAValuationReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
