package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ESMAPartyInformation;
import drr.regulation.common.NatureOfPartyEnum;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.trade.party.functions.ExtractRegimeInformation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ClearingThresholdOfCounterparty2Rule.ClearingThresholdOfCounterparty2RuleDefault.class)
public abstract class ClearingThresholdOfCounterparty2Rule implements ReportFunction<TransactionReportInstruction, List<Boolean>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractRegimeInformation extractRegimeInformation;
	@Inject protected IsAllowableAction isAllowableAction;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<Boolean> evaluate(TransactionReportInstruction input) {
		List<Boolean> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<Boolean> doEvaluate(TransactionReportInstruction input);

	public static class ClearingThresholdOfCounterparty2RuleDefault extends ClearingThresholdOfCounterparty2Rule {
		@Override
		protected List<Boolean> doEvaluate(TransactionReportInstruction input) {
			List<Boolean> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<Boolean> assignOutput(List<Boolean> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperC<ReportingRegime> thenArg1 = thenArg0
				.mapSingleToList(item -> {
					final ReferenceWithMetaParty referenceWithMetaParty = item.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingCounterparty", reportingSide -> reportingSide.getReportingCounterparty()).get();
					return MapperC.<ReportingRegime>of(extractRegimeInformation.evaluate(item.get(), (referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue())));
				});
			final MapperC<ReportingRegime> thenArg2 = thenArg1
				.filterItemNullSafe(item -> areEqual(MapperC.<NatureOfPartyEnum>of(MapperS.of(NatureOfPartyEnum.FINANCIAL), MapperS.of(NatureOfPartyEnum.NON_FINANCIAL)), item.<ESMAPartyInformation>map("getEsmaPartyInformation", reportingRegime -> reportingRegime.getEsmaPartyInformation()).<NatureOfPartyEnum>map("getNatureOfParty", eSMAPartyInformation -> eSMAPartyInformation.getNatureOfParty()), CardinalityOperator.Any).get());
			output = thenArg2
				.mapItem(item -> item.<ESMAPartyInformation>map("getEsmaPartyInformation", reportingRegime -> reportingRegime.getEsmaPartyInformation()).<Boolean>map("getExceedsClearingThreshold", eSMAPartyInformation -> eSMAPartyInformation.getExceedsClearingThreshold())).getMulti();
			
			return output;
		}
	}
}
