package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.base.staticdata.asset.common.TaxonomyValue;
import cdm.product.template.Basket;
import cdm.product.template.ContractualProduct;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ProductClassificationRule.ProductClassificationRuleDefault.class)
public abstract class ProductClassificationRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class ProductClassificationRuleDefault extends ProductClassificationRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final FieldWithMetaString fieldWithMetaString = thenArg1
				.mapSingleToItem(item -> {
					final MapperC<ProductTaxonomy> _thenArg0 = MapperC.<ProductTaxonomy>of(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<ProductTaxonomy>mapC("getProductTaxonomy", contractualProduct -> contractualProduct.getProductTaxonomy()), item.<Security>map("getSecurity", product -> product.getSecurity()).<ProductTaxonomy>mapC("getProductTaxonomy", security -> security.getProductTaxonomy()), item.<Basket>map("getBasket", product -> product.getBasket()).<ProductTaxonomy>mapC("getProductTaxonomy", basket -> basket.getProductTaxonomy()), item.<Index>map("getIndex", product -> product.getIndex()).<ProductTaxonomy>mapC("getProductTaxonomy", index -> index.getProductTaxonomy()), item.<Loan>map("getLoan", product -> product.getLoan()).<ProductTaxonomy>mapC("getProductTaxonomy", loan -> loan.getProductTaxonomy()))
						.filterItemNullSafe(_item -> areEqual(_item.<TaxonomySourceEnum>map("getSource", productTaxonomy -> productTaxonomy.getSource()), MapperS.of(TaxonomySourceEnum.CFI), CardinalityOperator.All).get());
					final MapperS<ProductTaxonomy> _thenArg1 = MapperS.of(_thenArg0.get());
					return _thenArg1
						.mapSingleToItem(_item -> _item.<TaxonomyValue>map("getValue", productTaxonomy -> productTaxonomy.getValue()).<FieldWithMetaString>map("getName", taxonomyValue -> taxonomyValue.getName()));
				}).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
