package drr.regulation.fca.ukemir.refit.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.margin.CollateralDetails;
import drr.regulation.common.CollateralReportInstruction;
import drr.regulation.common.functions.ExtractDateFromDateTime;
import java.time.ZonedDateTime;
import javax.inject.Inject;


@ImplementedBy(EventDateRule.EventDateRuleDefault.class)
public abstract class EventDateRule implements ReportFunction<CollateralReportInstruction, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractDateFromDateTime extractDateFromDateTime;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(CollateralReportInstruction input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(CollateralReportInstruction input);

	public static class EventDateRuleDefault extends EventDateRule {
		@Override
		protected Date doEvaluate(CollateralReportInstruction input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, CollateralReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(extractDateFromDateTime.evaluate(item.<CollateralDetails>map("getCollateralDetails", collateralReportInstruction -> collateralReportInstruction.getCollateralDetails()).<ZonedDateTime>map("getCollateralTimestamp", collateralDetails -> collateralDetails.getCollateralTimestamp()).get()))).get();
			
			return output;
		}
	}
}
