package drr.regulation.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.enrichment.common.EnrichmentData;
import drr.regulation.common.CommonTransactionInformation;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TradableOnTradingVenueEnum;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.functions.GetVenueOfExecution;
import drr.standards.iso.MicData;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(UKEMIRIsMicXOFF.UKEMIRIsMicXOFFDefault.class)
public abstract class UKEMIRIsMicXOFF implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetVenueOfExecution getVenueOfExecution;

	/**
	* @param reportableEvent 
	* @return isMicXOFF 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean isMicXOFF = doEvaluate(reportableEvent);
		
		return isMicXOFF;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	public static class UKEMIRIsMicXOFFDefault extends UKEMIRIsMicXOFF {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean isMicXOFF = null;
			return assignOutput(isMicXOFF, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean isMicXOFF, ReportableEvent reportableEvent) {
			isMicXOFF = notExists(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<EnrichmentData>map("getEnrichment", reportableInformation -> reportableInformation.getEnrichment()).<MicData>mapC("getMicData", enrichmentData -> enrichmentData.getMicData())).and(notExists(MapperS.of(getVenueOfExecution.evaluate(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).get())))).and(areEqual(MapperS.of(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<TransactionInformation>mapC("getTransactionInformation", reportableInformation -> reportableInformation.getTransactionInformation()).<CommonTransactionInformation>map("getFcaTransactionInformation", transactionInformation -> transactionInformation.getFcaTransactionInformation()).get()).<TradableOnTradingVenueEnum>map("getTradableOnTradingVenue", commonTransactionInformation -> commonTransactionInformation.getTradableOnTradingVenue()), MapperS.of(TradableOnTradingVenueEnum.ADMITTED), CardinalityOperator.All)).get();
			
			return isMicXOFF;
		}
	}
}
