package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.product.template.AmericanExercise;
import cdm.product.template.BermudaExercise;
import cdm.product.template.EuropeanExercise;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionPayout;
import cdm.product.template.OptionStyle;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsCap;
import drr.base.qualification.product.functions.IsFloor;
import drr.base.qualification.product.functions.IsOption;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.standards.iso.OptionStyleEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(OptionStyleRule.OptionStyleRuleDefault.class)
public abstract class OptionStyleRule implements ReportFunction<TransactionReportInstruction, OptionStyleEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsCap isCap;
	@Inject protected IsFloor isFloor;
	@Inject protected IsOption isOption;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public OptionStyleEnum evaluate(TransactionReportInstruction input) {
		OptionStyleEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract OptionStyleEnum doEvaluate(TransactionReportInstruction input);

	public static class OptionStyleRuleDefault extends OptionStyleRule {
		@Override
		protected OptionStyleEnum doEvaluate(TransactionReportInstruction input) {
			OptionStyleEnum output = null;
			return assignOutput(output, input);
		}
		
		protected OptionStyleEnum assignOutput(OptionStyleEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			output = thenArg1
				.mapSingleToItem(item -> {
					if (ComparisonResult.of(MapperS.of(isFloor.evaluate(item.get()))).or(ComparisonResult.of(MapperS.of(isCap.evaluate(item.get())))).getOrDefault(false)) {
						return MapperS.of(OptionStyleEnum.EURO);
					}
					final Boolean _boolean = isOption.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle())
							.mapSingleToItem(_item -> {
								if (exists(_item.<AmericanExercise>map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise())).getOrDefault(false)) {
									return MapperS.of(OptionStyleEnum.AMER);
								}
								if (exists(_item.<EuropeanExercise>map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise())).getOrDefault(false)) {
									return MapperS.of(OptionStyleEnum.EURO);
								}
								if (exists(_item.<BermudaExercise>map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise())).getOrDefault(false)) {
									return MapperS.of(OptionStyleEnum.BERM);
								}
								return MapperS.<OptionStyleEnum>ofNull();
							});
					}
					return MapperS.<OptionStyleEnum>ofNull();
				}).get();
			
			return output;
		}
	}
}
