package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iso.functions.IsMax32UpperCaseAlphanumericText;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(UTIProprietaryRule.UTIProprietaryRuleDefault.class)
public abstract class UTIProprietaryRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsMax32UpperCaseAlphanumericText isMax32UpperCaseAlphanumericText;
	@Inject protected UTIFCAValueRule uTIFCAValueRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class UTIProprietaryRuleDefault extends UTIProprietaryRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<String> thenArg = MapperS.of(uTIFCAValueRule.evaluate(input));
			output = thenArg
				.filterSingleNullSafe(item -> areEqual(MapperS.of(isMax32UpperCaseAlphanumericText.evaluate(item.get())), MapperS.of(false), CardinalityOperator.All).get()).get();
			
			return output;
		}
	}
}
