package drr.regulation.hkma.rewrite.trade.reports;

import cdm.event.common.TradeIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.hkma.rewrite.trade.functions.Extract_HKMATradeIdentifier;
import drr.regulation.hkma.rewrite.trade.functions.Extract_PriorUTIPropietary;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PriorUTIProprietaryRule.PriorUTIProprietaryRuleDefault.class)
public abstract class PriorUTIProprietaryRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Extract_HKMATradeIdentifier extract_HKMATradeIdentifier;
	@Inject protected Extract_PriorUTIPropietary extract_PriorUTIPropietary;
	@Inject protected PriorUTIRule priorUTIRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class PriorUTIProprietaryRuleDefault extends PriorUTIProprietaryRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TradeIdentifier> thenArg;
			if (notExists(MapperS.of(priorUTIRule.evaluate(input))).getOrDefault(false)) {
				thenArg = MapperS.of(extract_PriorUTIPropietary.evaluate(input));
			} else {
				thenArg = MapperS.<TradeIdentifier>ofNull();
			}
			output = MapperS.of(extract_HKMATradeIdentifier.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
