package drr.regulation.jfsa.rewrite.margin.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.jfsa.rewrite.margin.CollateralReport;
import drr.regulation.jfsa.rewrite.margin.JFSAMarginReport;
import drr.regulation.jfsa.rewrite.margin.PartiesToTheDerivative;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class JFSAMarginReportValidator implements Validator<JFSAMarginReport> {

	private List<ComparisonResult> getComparisonResults(JFSAMarginReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("partiesToTheDerivative", (PartiesToTheDerivative) o.getPartiesToTheDerivative() != null ? 1 : 0, 1, 1), 
				checkCardinality("collateral", (CollateralReport) o.getCollateral() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSAMarginReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("JFSAMarginReport", ValidationResult.ValidationType.CARDINALITY, "JFSAMarginReport", path, "", res.getError());
				}
				return success("JFSAMarginReport", ValidationResult.ValidationType.CARDINALITY, "JFSAMarginReport", path, "");
			})
			.collect(toList());
	}

}
