package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.datetime.reports.FixingDateLeg1Rule;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodLeg1Rule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodMultiplierLeg1Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateIndicatorLeg1Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateReferencePeriodLeg1Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateReferencePeriodMultiplierLeg1Rule;
import drr.regulation.common.trade.underlier.reports.NameOfTheFloatingRateOfLeg1Rule;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import drr.standards.iosco.cde.version3.functions.Leg1;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleLeg1Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleLeg1Rule;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Leg1ReportRule.Leg1ReportRuleDefault.class)
public abstract class Leg1ReportRule implements ReportFunction<TransactionReportInstruction, CommonLeg> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected FixingDateLeg1Rule fixingDateLeg1Rule;
	@Inject protected FloatingRateIndicatorLeg1Rule floatingRateIndicatorLeg1Rule;
	@Inject protected FloatingRateReferencePeriodLeg1Rule floatingRateReferencePeriodLeg1Rule;
	@Inject protected FloatingRateReferencePeriodMultiplierLeg1Rule floatingRateReferencePeriodMultiplierLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodLeg1Rule floatingRateResetFrequencyPeriodLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierLeg1Rule floatingRateResetFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected IsAllowableActionForJFSA isAllowableActionForJFSA;
	@Inject protected Leg1 leg1;
	@Inject protected LegEnrichment legEnrichment;
	@Inject protected NameOfTheFloatingRateOfLeg1Rule nameOfTheFloatingRateOfLeg1Rule;
	@Inject protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
	@Inject protected NotionalQuantityScheduleLeg1Rule notionalQuantityScheduleLeg1Rule;
	@Inject protected SpreadNotationOfLeg1Rule spreadNotationOfLeg1Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CommonLeg evaluate(TransactionReportInstruction input) {
		CommonLeg.CommonLegBuilder outputBuilder = doEvaluate(input);
		
		final CommonLeg output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CommonLeg.class, output);
		}
		
		return output;
	}

	protected abstract CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input);

	public static class Leg1ReportRuleDefault extends Leg1ReportRule {
		@Override
		protected CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input) {
			CommonLeg.CommonLegBuilder output = CommonLeg.builder();
			return assignOutput(output, input);
		}
		
		protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForJFSA.evaluate(item.get()));
			final BigInteger bigInteger = new BigInteger("9999999999999999999999999");
			final BigDecimal bigDecimal = floatingRateReferencePeriodMultiplierLeg1Rule.evaluate(thenArg.get());
			output = toBuilder(MapperS.of(legEnrichment.evaluate(leg1.evaluate(thenArg.get(), spreadNotationOfLeg1Rule.evaluate(thenArg.get()), (bigInteger == null ? null : new BigDecimal(bigInteger))), notionalAmountScheduleLeg1Rule.evaluate(thenArg.get()), notionalQuantityScheduleLeg1Rule.evaluate(thenArg.get()), null, floatingRateResetFrequencyPeriodLeg1Rule.evaluate(thenArg.get()), floatingRateResetFrequencyPeriodMultiplierLeg1Rule.evaluate(thenArg.get()), fixingDateLeg1Rule.evaluate(thenArg.get()), null, null, floatingRateIndicatorLeg1Rule.evaluate(thenArg.get()), null, floatingRateReferencePeriodLeg1Rule.evaluate(thenArg.get()), (bigDecimal == null ? null : bigDecimal.intValueExact()), nameOfTheFloatingRateOfLeg1Rule.evaluate(thenArg.get()))).get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
