package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.EnrichmentDataRule;
import drr.enrichment.common.reports.UpiPostEnrichmentDataRule;
import drr.enrichment.common.reports.UpiPreEnrichmentDataRule;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.party.reports.ReportSubmittingEntityRule;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.labels.MASTradeLabelProvider;
import drr.standards.iosco.cde.version3.datetime.reports.EventTimestampRule;
import drr.standards.iosco.cde.version3.datetime.reports.ReportingTimestampRule;
import drr.standards.iosco.cde.version3.event.reports.ActionTypeRule;
import drr.standards.iosco.cde.version3.event.reports.EventTypeRule;
import drr.standards.iosco.cde.version3.party.reports.Counterparty1Rule;
import drr.standards.iosco.cde.version3.party.reports.Counterparty2IdentifierTypeIndicatorRule;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.mas.rewrite.trade", body="MAS", corpusList={"Trade"})
@RuneLabelProvider(labelProvider=MASTradeLabelProvider.class)
@ImplementedBy(MASTradeReportFunction.MASTradeReportFunctionDefault.class)
public abstract class MASTradeReportFunction implements ReportFunction<TransactionReportInstruction, MASTransactionReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected AssetClassRule assetClassRule;
	@Inject protected BasketConstituentsRule basketConstituentsRule;
	@Inject protected BookingLocationRule bookingLocationRule;
	@Inject protected CallAmountRule callAmountRule;
	@Inject protected CallCurrencyRule callCurrencyRule;
	@Inject protected CentralCounterpartyRule centralCounterpartyRule;
	@Inject protected ClearedRule clearedRule;
	@Inject protected ClearingMemberRule clearingMemberRule;
	@Inject protected ClearingTimestampRule clearingTimestampRule;
	@Inject protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
	@Inject protected ConfirmationTimestampRule confirmationTimestampRule;
	@Inject protected ConfirmedRule confirmedRule;
	@Inject protected ContractPriceScheduleRule contractPriceScheduleRule;
	@Inject protected ContractTypeRule contractTypeRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierTypeIndicatorRule counterparty2IdentifierTypeIndicatorRule;
	@Inject protected Counterparty2NameDTCCRule counterparty2NameDTCCRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected DeliveryTypeRule deliveryTypeRule;
	@Inject protected DirectionRule directionRule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected EnrichmentDataRule enrichmentDataRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected EventTypeRule eventTypeRule;
	@Inject protected ExchangeRateBasisRule exchangeRateBasisRule;
	@Inject protected ExchangeRateRule exchangeRateRule;
	@Inject protected ExecutionAgentCounterparty1DTCCRule executionAgentCounterparty1DTCCRule;
	@Inject protected ExecutionAgentCounterparty2DTCCRule executionAgentCounterparty2DTCCRule;
	@Inject protected ExecutionTimestampRule executionTimestampRule;
	@Inject protected ExpirationDateRule expirationDateRule;
	@Inject protected FinalContractualSettlementDateRule finalContractualSettlementDateRule;
	@Inject protected FirstExerciseDateRule firstExerciseDateRule;
	@Inject protected InitialMarginCollateralPortfolioCodeDTCCRule initialMarginCollateralPortfolioCodeDTCCRule;
	@Inject protected Leg1ReportRule leg1ReportRule;
	@Inject protected Leg2ReportRule leg2ReportRule;
	@Inject protected NameOfTheUnderlyingIndexDTCCRule nameOfTheUnderlyingIndexDTCCRule;
	@Inject protected OptionPremiumAmountRule optionPremiumAmountRule;
	@Inject protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
	@Inject protected OptionStyleRule optionStyleRule;
	@Inject protected OptionTypeRule optionTypeRule;
	@Inject protected OtherPaymentRule otherPaymentRule;
	@Inject protected PackageIdentifierRule packageIdentifierRule;
	@Inject protected PlatformIdentifierRule platformIdentifierRule;
	@Inject protected PriceCurrencyRule priceCurrencyRule;
	@Inject protected PriceNotationRule priceNotationRule;
	@Inject protected PriceRule priceRule;
	@Inject protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
	@Inject protected PriorUTIProprietaryRule priorUTIProprietaryRule;
	@Inject protected PriorUTIRule priorUTIRule;
	@Inject protected PutAmountRule putAmountRule;
	@Inject protected PutCurrencyRule putCurrencyRule;
	@Inject protected ReportSubmittingEntityRule reportSubmittingEntityRule;
	@Inject protected ReportingSpecifiedPersonRule reportingSpecifiedPersonRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected StrikePriceCurrencyCurrencyPairRule strikePriceCurrencyCurrencyPairRule;
	@Inject protected StrikePriceNotationRule strikePriceNotationRule;
	@Inject protected StrikePriceRule strikePriceRule;
	@Inject protected StrikePriceScheduleRule strikePriceScheduleRule;
	@Inject protected SwapLinkIDRule swapLinkIDRule;
	@Inject protected TechnicalRecordIdRule technicalRecordIdRule;
	@Inject protected TraderLocationRule traderLocationRule;
	@Inject protected TradingCapacityOfSpecifiedPersonRule tradingCapacityOfSpecifiedPersonRule;
	@Inject protected UnderlyingIdOtherDTCCRule underlyingIdOtherDTCCRule;
	@Inject protected UnderlyingIdOtherSourceDTCCRule underlyingIdOtherSourceDTCCRule;
	@Inject protected UnderlyingIdentificationTypeDTCCRule underlyingIdentificationTypeDTCCRule;
	@Inject protected UnderlyingRule underlyingRule;
	@Inject protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
	@Inject protected UniqueTransactionIdentifierProprietaryRule uniqueTransactionIdentifierProprietaryRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
	@Inject protected UpiPostEnrichmentDataRule upiPostEnrichmentDataRule;
	@Inject protected UpiPreEnrichmentDataRule upiPreEnrichmentDataRule;
	@Inject protected ValuationAmountRule valuationAmountRule;
	@Inject protected ValuationCurrencyRule valuationCurrencyRule;
	@Inject protected ValuationMethodRule valuationMethodRule;
	@Inject protected ValuationTimestampRule valuationTimestampRule;
	@Inject protected VariationMarginCollateralPortfolioCodeDTCCRule variationMarginCollateralPortfolioCodeDTCCRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public MASTransactionReport evaluate(TransactionReportInstruction input) {
		MASTransactionReport.MASTransactionReportBuilder outputBuilder = doEvaluate(input);
		
		final MASTransactionReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(MASTransactionReport.class, output);
		}
		
		return output;
	}

	protected abstract MASTransactionReport.MASTransactionReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class MASTradeReportFunctionDefault extends MASTradeReportFunction {
		@Override
		protected MASTransactionReport.MASTransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
			MASTransactionReport.MASTransactionReportBuilder output = MASTransactionReport.builder();
			return assignOutput(output, input);
		}
		
		protected MASTransactionReport.MASTransactionReportBuilder assignOutput(MASTransactionReport.MASTransactionReportBuilder output, TransactionReportInstruction input) {
			output
				.setEffectiveDate(effectiveDateRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setExecutionTimestamp(executionTimestampRule.evaluate(input));
			
			output
				.setExpirationDate(expirationDateRule.evaluate(input));
			
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierTypeOverriddenAsBoolean(counterparty2IdentifierTypeIndicatorRule.evaluate(input));
			
			output
				.setClearedOverriddenAsClearedEnum(clearedRule.evaluate(input));
			
			output
				.setCentralCounterparty(centralCounterpartyRule.evaluate(input));
			
			output
				.setClearingMember(clearingMemberRule.evaluate(input));
			
			output
				.setConfirmed(confirmedRule.evaluate(input));
			
			output
				.setCallAmount(callAmountRule.evaluate(input));
			
			output
				.setPutAmount(putAmountRule.evaluate(input));
			
			output
				.setCallCurrency(callCurrencyRule.evaluate(input));
			
			output
				.setPutCurrency(putCurrencyRule.evaluate(input));
			
			output
				.setPriceSchedule(contractPriceScheduleRule.evaluate(input));
			
			output
				.setStrikePriceSchedule(strikePriceScheduleRule.evaluate(input));
			
			output
				.setPrice(priceRule.evaluate(input));
			
			output
				.setPriceNotation(priceNotationRule.evaluate(input));
			
			output
				.setPriceCurrency(priceCurrencyRule.evaluate(input));
			
			output
				.setPackageIdentifier(packageIdentifierRule.evaluate(input));
			
			output
				.setStrikePrice(strikePriceRule.evaluate(input));
			
			output
				.setStrikePriceNotation(strikePriceNotationRule.evaluate(input));
			
			output
				.setStrikePriceCurrency(strikePriceCurrencyCurrencyPairRule.evaluate(input));
			
			output
				.setPriceUnitOfMeasure(priceUnitOfMeasureRule.evaluate(input));
			
			output
				.setOptionPremiumAmount(optionPremiumAmountRule.evaluate(input));
			
			output
				.setOptionPremiumCurrency(optionPremiumCurrencyRule.evaluate(input));
			
			output
				.setExchangeRate(exchangeRateRule.evaluate(input));
			
			output
				.setExchangeRateBasis(exchangeRateBasisRule.evaluate(input));
			
			output
				.setCollateralPortfolioIndicator(collateralPortfolioIndicatorRule.evaluate(input));
			
			output
				.setFirstExerciseDate(firstExerciseDateRule.evaluate(input));
			
			output
				.setFinalContractualSettlementDate(finalContractualSettlementDateRule.evaluate(input));
			
			output
				.setPriorUTI(priorUTIRule.evaluate(input));
			
			output
				.setValuationAmount(valuationAmountRule.evaluate(input));
			
			output
				.setValuationCurrency(valuationCurrencyRule.evaluate(input));
			
			output
				.setValuationMethod(valuationMethodRule.evaluate(input));
			
			output
				.setValuationTimestamp(valuationTimestampRule.evaluate(input));
			
			output
				.setBasketConstituents(basketConstituentsRule.evaluate(input));
			
			output
				.setOtherPayment(otherPaymentRule.evaluate(input));
			
			output
				.setLeg1(leg1ReportRule.evaluate(input));
			
			output
				.setLeg2(leg2ReportRule.evaluate(input));
			
			output
				.setUnderlyingIdOther(underlyingIdOtherDTCCRule.evaluate(input));
			
			output
				.setUnderlyingIdOtherSource(underlyingIdOtherSourceDTCCRule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventType(eventTypeRule.evaluate(input));
			
			output
				.setEventTimestampOverriddenAsZonedDateTime(eventTimestampRule.evaluate(input));
			
			output
				.setCounterparty2Name(counterparty2NameDTCCRule.evaluate(input));
			
			output
				.setExecutionAgentCounterparty1(executionAgentCounterparty1DTCCRule.evaluate(input));
			
			output
				.setExecutionAgentCounterparty2(executionAgentCounterparty2DTCCRule.evaluate(input));
			
			output
				.setReportSubmittingEntityID(reportSubmittingEntityRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifierProprietary(uniqueTransactionIdentifierProprietaryRule.evaluate(input));
			
			output
				.setPriorUTIProprietary(priorUTIProprietaryRule.evaluate(input));
			
			output
				.setUniqueProductIdentifier(uniqueProductIdentifierRule.evaluate(input));
			
			output
				.setContractTypeOverriddenAsCommonContractType(contractTypeRule.evaluate(input));
			
			output
				.setAssetClassOverriddenAsCommonAssetClass(assetClassRule.evaluate(input));
			
			output
				.setClearingTimestamp(clearingTimestampRule.evaluate(input));
			
			output
				.setPlatformIdentifier(platformIdentifierRule.evaluate(input));
			
			output
				.setDirection1(directionRule.evaluate(input));
			
			output
				.setNameOfTheUnderlyingIndex(nameOfTheUnderlyingIndexDTCCRule.evaluate(input));
			
			output
				.setOptionType(optionTypeRule.evaluate(input));
			
			output
				.setOptionStyle(optionStyleRule.evaluate(input));
			
			output
				.setDeliveryType(deliveryTypeRule.evaluate(input));
			
			output
				.setBookingLocation(bookingLocationRule.evaluate(input));
			
			output
				.setTraderLocation(traderLocationRule.evaluate(input));
			
			output
				.setTradingCapacity(tradingCapacityOfSpecifiedPersonRule.evaluate(input));
			
			output
				.setTechnicalRecordIdOverriddenAsString(technicalRecordIdRule.evaluate(input));
			
			output
				.setInitialMarginCollateralPortfolioCode(initialMarginCollateralPortfolioCodeDTCCRule.evaluate(input));
			
			output
				.setVariationMarginCollateralPortfolioCodeOverriddenAsString(variationMarginCollateralPortfolioCodeDTCCRule.evaluate(input));
			
			output
				.setConfirmationTimestamp(confirmationTimestampRule.evaluate(input));
			
			output
				.setSwapLinkID(swapLinkIDRule.evaluate(input));
			
			output
				.setUnderlyingIdentification(underlyingRule.evaluate(input));
			
			output
				.setUnderlyingIdentificationType(underlyingIdentificationTypeDTCCRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setEnrichment(enrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPreUpiData(upiPreEnrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPostUpiData(upiPostEnrichmentDataRule.evaluate(input));
			
			output
				.setReportingSpecifiedPerson(reportingSpecifiedPersonRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
