package drr.standards.iosco.cde.version1.basket.reports;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.asset.CommodityPayout;
import cdm.product.template.Basket;
import cdm.product.template.BasketConstituent;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.TransactionReportInstruction;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(BasketConstituentNumberOfUnitsRule.BasketConstituentNumberOfUnitsRuleDefault.class)
public abstract class BasketConstituentNumberOfUnitsRule implements ReportFunction<TransactionReportInstruction, List<BigDecimal>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<BigDecimal> evaluate(TransactionReportInstruction input) {
		List<BigDecimal> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<BigDecimal> doEvaluate(TransactionReportInstruction input);

	public static class BasketConstituentNumberOfUnitsRuleDefault extends BasketConstituentNumberOfUnitsRule {
		@Override
		protected List<BigDecimal> doEvaluate(TransactionReportInstruction input) {
			List<BigDecimal> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<BigDecimal> assignOutput(List<BigDecimal> output, TransactionReportInstruction input) {
			final MapperS<Product> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<Payout> thenArg1 = thenArg0
				.mapSingleToItem(item -> item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()));
			final MapperC<Basket> thenArg2 = thenArg1
				.mapSingleToList(item -> {
					if (exists(item.<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<Basket>map("getBasket", product -> product.getBasket())).getOrDefault(false)) {
						return item.<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<Basket>map("getBasket", product -> product.getBasket());
					}
					if (exists(item.<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).<Basket>map("getBasket", product -> product.getBasket())).getOrDefault(false)) {
						return item.<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).<Basket>map("getBasket", product -> product.getBasket());
					}
					if (exists(item.<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Basket>map("getBasket", product -> product.getBasket())).getOrDefault(false)) {
						return item.<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Basket>map("getBasket", product -> product.getBasket());
					}
					if (exists(item.<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Basket>map("getBasket", product -> product.getBasket())).getOrDefault(false)) {
						return item.<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Basket>map("getBasket", product -> product.getBasket());
					}
					return MapperC.<Basket>ofNull();
				});
			final MapperListOfLists<BigDecimal> thenArg3 = thenArg2
				.mapItemToList(item -> item.<BasketConstituent>mapC("getPortfolioBasketConstituent", basket -> basket.getPortfolioBasketConstituent()).<ReferenceWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", basketConstituent -> basketConstituent.getQuantity()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
			output = thenArg3
				.flattenList().getMulti();
			
			return output;
		}
	}
}
