package drr.standards.iosco.cde.version1.basket.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.basket.functions.GetBasketConstituentsProductIdentifier;
import drr.base.trade.functions.TradeForEvent;
import drr.regulation.common.ReportableEvent;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;


@ImplementedBy(SourceOfTheIdentifierOfTheBasketConstituentsRule.SourceOfTheIdentifierOfTheBasketConstituentsRuleDefault.class)
public abstract class SourceOfTheIdentifierOfTheBasketConstituentsRule implements ReportFunction<ReportableEvent, List<ProductIdTypeEnum>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetBasketConstituentsProductIdentifier getBasketConstituentsProductIdentifier;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<ProductIdTypeEnum> evaluate(ReportableEvent input) {
		List<ProductIdTypeEnum> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<ProductIdTypeEnum> doEvaluate(ReportableEvent input);

	public static class SourceOfTheIdentifierOfTheBasketConstituentsRuleDefault extends SourceOfTheIdentifierOfTheBasketConstituentsRule {
		@Override
		protected List<ProductIdTypeEnum> doEvaluate(ReportableEvent input) {
			List<ProductIdTypeEnum> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<ProductIdTypeEnum> assignOutput(List<ProductIdTypeEnum> output, ReportableEvent input) {
			final MapperS<Trade> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			output = thenArg
				.mapSingleToList(item -> MapperC.<ProductIdentifier>of(getBasketConstituentsProductIdentifier.evaluate(item.get())).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource())).getMulti();
			
			return output;
		}
	}
}
