package drr.standards.iosco.cde.version1.datetime.functions;

import cdm.event.common.Valuation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.time.ZonedDateTime;


@ImplementedBy(ValuationTimestampFromValuation.ValuationTimestampFromValuationDefault.class)
public abstract class ValuationTimestampFromValuation implements RosettaFunction {

	/**
	* @param valuation 
	* @return valuationTimestamp 
	*/
	public ZonedDateTime evaluate(Valuation valuation) {
		ZonedDateTime valuationTimestamp = doEvaluate(valuation);
		
		return valuationTimestamp;
	}

	protected abstract ZonedDateTime doEvaluate(Valuation valuation);

	public static class ValuationTimestampFromValuationDefault extends ValuationTimestampFromValuation {
		@Override
		protected ZonedDateTime doEvaluate(Valuation valuation) {
			ZonedDateTime valuationTimestamp = null;
			return assignOutput(valuationTimestamp, valuation);
		}
		
		protected ZonedDateTime assignOutput(ZonedDateTime valuationTimestamp, Valuation valuation) {
			valuationTimestamp = MapperS.of(valuation).<ZonedDateTime>map("getTimestamp", _valuation -> _valuation.getTimestamp()).get();
			
			return valuationTimestamp;
		}
	}
}
