package drr.standards.iosco.cde.version1.party.functions;

import cdm.base.staticdata.party.BuyerSeller;
import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyIdentifier;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.qualification.functions.Qualify_InterestRate_Forward_Debt;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCapFloor;
import drr.base.qualification.product.functions.IsCommodityForward;
import drr.base.qualification.product.functions.IsCreditDefaultSwap;
import drr.base.qualification.product.functions.IsEquityForward;
import drr.base.qualification.product.functions.IsProductETD;
import drr.base.qualification.product.functions.IsSingleCommodityPayoutProduct;
import drr.base.qualification.product.functions.IsTotalReturnSwapDebtUnderlier;
import drr.base.qualification.product.functions.IsVarianceSwap;
import drr.base.qualification.product.functions.IsVolatilitySwap;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.TradableProductForEvent;
import drr.base.util.party.functions.PartyLei;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version1.party.reports.Counterparty1Rule;
import drr.standards.iso.Direction1Enum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Direction1.Direction1Default.class)
public abstract class Direction1 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected ExtractCounterpartyByRole extractCounterpartyByRole;
	@Inject protected IsCapFloor isCapFloor;
	@Inject protected IsCommodityForward isCommodityForward;
	@Inject protected IsCreditDefaultSwap isCreditDefaultSwap;
	@Inject protected IsEquityForward isEquityForward;
	@Inject protected IsProductETD isProductETD;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
	@Inject protected IsTotalReturnSwapDebtUnderlier isTotalReturnSwapDebtUnderlier;
	@Inject protected IsVarianceSwap isVarianceSwap;
	@Inject protected IsVolatilitySwap isVolatilitySwap;
	@Inject protected PartyLei partyLei;
	@Inject protected Qualify_InterestRate_Forward_Debt qualify_InterestRate_Forward_Debt;
	@Inject protected TradableProductForEvent tradableProductForEvent;

	/**
	* @param event 
	* @return direction 
	*/
	public Direction1Enum evaluate(TransactionReportInstruction event) {
		Direction1Enum direction = doEvaluate(event);
		
		return direction;
	}

	protected abstract Direction1Enum doEvaluate(TransactionReportInstruction event);

	protected abstract MapperS<? extends TradableProduct> tradableProduct(TransactionReportInstruction event);

	protected abstract MapperS<String> reportingParty(TransactionReportInstruction event);

	protected abstract MapperS<? extends Counterparty> buyer(TransactionReportInstruction event);

	protected abstract MapperS<? extends Counterparty> seller(TransactionReportInstruction event);

	public static class Direction1Default extends Direction1 {
		@Override
		protected Direction1Enum doEvaluate(TransactionReportInstruction event) {
			Direction1Enum direction = null;
			return assignOutput(direction, event);
		}
		
		protected Direction1Enum assignOutput(Direction1Enum direction, TransactionReportInstruction event) {
			if (areEqual(reportingParty(event), MapperS.of(partyLei.evaluate(buyer(event).<ReferenceWithMetaParty>map("getPartyReference", counterparty -> counterparty.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()).<PartyIdentifier>mapC("getPartyId", party -> party.getPartyId()).getMulti())), CardinalityOperator.All).getOrDefault(false)) {
				direction = Direction1Enum.BYER;
			} else if (areEqual(reportingParty(event), MapperS.of(partyLei.evaluate(seller(event).<ReferenceWithMetaParty>map("getPartyReference", counterparty -> counterparty.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()).<PartyIdentifier>mapC("getPartyId", party -> party.getPartyId()).getMulti())), CardinalityOperator.All).getOrDefault(false)) {
				direction = Direction1Enum.SLLR;
			} else {
				direction = null;
			}
			
			return direction;
		}
		
		@Override
		protected MapperS<? extends TradableProduct> tradableProduct(TransactionReportInstruction event) {
			return MapperS.of(tradableProductForEvent.evaluate(event));
		}
		
		@Override
		protected MapperS<String> reportingParty(TransactionReportInstruction event) {
			return MapperS.of(counterparty1Rule.evaluate(event));
		}
		
		@Override
		protected MapperS<? extends Counterparty> buyer(TransactionReportInstruction event) {
			if (exists(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout())).getOrDefault(false)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<BuyerSeller>map("getBuyerSeller", optionPayout -> optionPayout.getBuyerSeller()).<CounterpartyRoleEnum>map("getBuyer", buyerSeller -> buyerSeller.getBuyer()).get()));
			}
			final Boolean boolean0 = isCreditDefaultSwap.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<PayerReceiver>map("getPayerReceiver", creditDefaultPayout -> creditDefaultPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
			}
			if (ComparisonResult.of(MapperS.of(isVarianceSwap.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get()))).or(ComparisonResult.of(MapperS.of(isVolatilitySwap.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())))).getOrDefault(false)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<PayerReceiver>map("getPayerReceiver", performancePayout -> performancePayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
			}
			final Boolean boolean1 = isCapFloor.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
			if ((boolean1 == null ? false : boolean1)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()).<PayerReceiver>map("getPayerReceiver", interestRatePayout -> interestRatePayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()));
			}
			if (ComparisonResult.of(MapperS.of(isProductETD.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get()))).and(exists(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()))).getOrDefault(false)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<PayerReceiver>map("getPayerReceiver", forwardPayout -> forwardPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()));
			}
			final Boolean boolean2 = isSingleCommodityPayoutProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
			if ((boolean2 == null ? false : boolean2)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<PayerReceiver>map("getPayerReceiver", commodityPayout -> commodityPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()));
			}
			final Boolean boolean3 = isCommodityForward.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
			if ((boolean3 == null ? false : boolean3)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<PayerReceiver>map("getPayerReceiver", forwardPayout -> forwardPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
			}
			final Boolean boolean4 = qualify_InterestRate_Forward_Debt.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
			if ((boolean4 == null ? false : boolean4)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<PayerReceiver>map("getPayerReceiver", forwardPayout -> forwardPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()));
			}
			final Boolean boolean5 = isTotalReturnSwapDebtUnderlier.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
			if ((boolean5 == null ? false : boolean5)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<PayerReceiver>map("getPayerReceiver", performancePayout -> performancePayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()));
			}
			final Boolean boolean6 = isEquityForward.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
			if ((boolean6 == null ? false : boolean6)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<PayerReceiver>map("getPayerReceiver", forwardPayout -> forwardPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()));
			}
			return MapperS.<Counterparty>ofNull();
		}
		
		@Override
		protected MapperS<? extends Counterparty> seller(TransactionReportInstruction event) {
			if (exists(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout())).getOrDefault(false)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<BuyerSeller>map("getBuyerSeller", optionPayout -> optionPayout.getBuyerSeller()).<CounterpartyRoleEnum>map("getSeller", buyerSeller -> buyerSeller.getSeller()).get()));
			}
			final Boolean boolean0 = isCreditDefaultSwap.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<PayerReceiver>map("getPayerReceiver", creditDefaultPayout -> creditDefaultPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()));
			}
			if (ComparisonResult.of(MapperS.of(isVarianceSwap.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get()))).or(ComparisonResult.of(MapperS.of(isVolatilitySwap.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())))).getOrDefault(false)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<PayerReceiver>map("getPayerReceiver", performancePayout -> performancePayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()));
			}
			final Boolean boolean1 = isCapFloor.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
			if ((boolean1 == null ? false : boolean1)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()).<PayerReceiver>map("getPayerReceiver", interestRatePayout -> interestRatePayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
			}
			if (ComparisonResult.of(MapperS.of(isProductETD.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get()))).and(exists(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()))).getOrDefault(false)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<PayerReceiver>map("getPayerReceiver", forwardPayout -> forwardPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
			}
			final Boolean boolean2 = isSingleCommodityPayoutProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
			if ((boolean2 == null ? false : boolean2)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(MapperS.of(economicTermsForProduct.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<PayerReceiver>map("getPayerReceiver", commodityPayout -> commodityPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
			}
			final Boolean boolean3 = isCommodityForward.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
			if ((boolean3 == null ? false : boolean3)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<PayerReceiver>map("getPayerReceiver", forwardPayout -> forwardPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()));
			}
			final Boolean boolean4 = qualify_InterestRate_Forward_Debt.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
			if ((boolean4 == null ? false : boolean4)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<PayerReceiver>map("getPayerReceiver", forwardPayout -> forwardPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
			}
			final Boolean boolean5 = isTotalReturnSwapDebtUnderlier.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
			if ((boolean5 == null ? false : boolean5)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<PayerReceiver>map("getPayerReceiver", performancePayout -> performancePayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
			}
			final Boolean boolean6 = isEquityForward.evaluate(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
			if ((boolean6 == null ? false : boolean6)) {
				return MapperS.of(extractCounterpartyByRole.evaluate(tradableProduct(event).<Counterparty>mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti(), MapperS.of(tradableProduct(event).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<PayerReceiver>map("getPayerReceiver", forwardPayout -> forwardPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
			}
			return MapperS.<Counterparty>ofNull();
		}
	}
}
