package drr.standards.iosco.cde.version1.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.price.functions.CurrencyPairOrCurrencyFromPrice;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version1.price.functions.StrikePrice;
import javax.inject.Inject;


@ImplementedBy(StrikePriceCurrencyRule.StrikePriceCurrencyRuleDefault.class)
public abstract class StrikePriceCurrencyRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CurrencyPairOrCurrencyFromPrice currencyPairOrCurrencyFromPrice;
	@Inject protected StrikePrice strikePrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class StrikePriceCurrencyRuleDefault extends StrikePriceCurrencyRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			output = currencyPairOrCurrencyFromPrice.evaluate(strikePrice.evaluate(input), true);
			
			return output;
		}
	}
}
