package drr.standards.iosco.cde.version1.quantity.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.quantity.functions.GetProductForQuantity;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.PayoutLeg2;
import drr.standards.iosco.cde.version1.quantity.functions.CurrencyFromNotional;
import drr.standards.iosco.cde.version1.quantity.functions.NotionalFromLeg;
import javax.inject.Inject;


@ImplementedBy(NotionalCurrencyLeg2Rule.NotionalCurrencyLeg2RuleDefault.class)
public abstract class NotionalCurrencyLeg2Rule implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CurrencyFromNotional currencyFromNotional;
	@Inject protected GetProductForQuantity getProductForQuantity;
	@Inject protected NotionalFromLeg notionalFromLeg;
	@Inject protected PayoutLeg2 payoutLeg2;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
		ISOCurrencyCodeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input);

	public static class NotionalCurrencyLeg2RuleDefault extends NotionalCurrencyLeg2Rule {
		@Override
		protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
			ISOCurrencyCodeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(reportableEvent -> {
					final MapperS<TradableProduct> thenArg = MapperS.of(getProductForQuantity.evaluate(input));
					return MapperS.of(currencyFromNotional.evaluate(notionalFromLeg.evaluate(thenArg
						.mapSingleToItem(item -> MapperS.of(payoutLeg2.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get(), item.<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get()))).get())));
				}).get();
			
			return output;
		}
	}
}
