package drr.standards.iosco.cde.version2.party.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version1.party.reports.Beneficiary1IdentifierTypeIndicatorRule;
import javax.inject.Inject;


@ImplementedBy(Beneficiary1IdentifierTypeRule.Beneficiary1IdentifierTypeRuleDefault.class)
public abstract class Beneficiary1IdentifierTypeRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Beneficiary1IdentifierTypeIndicatorRule beneficiary1IdentifierTypeIndicatorRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class Beneficiary1IdentifierTypeRuleDefault extends Beneficiary1IdentifierTypeRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			output = beneficiary1IdentifierTypeIndicatorRule.evaluate(input);
			
			return output;
		}
	}
}
