package drr.standards.iosco.cde.version2.payment.reports;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(PaymentFrequencyPeriodMultiplierAdjustedRule.PaymentFrequencyPeriodMultiplierAdjustedRuleDefault.class)
public abstract class PaymentFrequencyPeriodMultiplierAdjustedRule implements ReportFunction<InterestRatePayout, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version1.payment.reports.PaymentFrequencyPeriodMultiplierAdjustedRule paymentFrequencyPeriodMultiplierAdjustedRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(InterestRatePayout input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(InterestRatePayout input);

	public static class PaymentFrequencyPeriodMultiplierAdjustedRuleDefault extends PaymentFrequencyPeriodMultiplierAdjustedRule {
		@Override
		protected BigDecimal doEvaluate(InterestRatePayout input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, InterestRatePayout input) {
			output = paymentFrequencyPeriodMultiplierAdjustedRule.evaluate(input);
			
			return output;
		}
	}
}
