package drr.standards.iosco.cde.version3.functions;

import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.functions.PriceFormatFromNotation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.common.functions.SettlementTermsLeg1;
import drr.regulation.common.reports.PayoutFromProductLeg1Rule;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iosco.cde.version3.execution.reports.SettlementCurrencyRule;
import drr.standards.iosco.cde.version3.party.reports.Direction2Leg1Rule;
import drr.standards.iosco.cde.version3.payment.reports.PeriodicPaymentRule;
import drr.standards.iosco.cde.version3.price.reports.InterestRateFixedRateRule;
import drr.standards.iosco.cde.version3.price.reports.SpreadCurrencyRule;
import drr.standards.iosco.cde.version3.price.reports.SpreadValueRule;
import drr.standards.iosco.cde.version3.quantity.functions.NotionalAmountLeg1;
import drr.standards.iosco.cde.version3.quantity.functions.TotalNotionalQuantityLeg1;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleLeg1Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalCurrencyLeg1Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleLeg1Rule;
import drr.standards.iosco.cde.version3.quantity.reports.QuantityUnitOfMeasureLeg1Rule;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Leg1.Leg1Default.class)
public abstract class Leg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Direction2Leg1Rule direction2Leg1Rule;
	@Inject protected InterestRateFixedRateRule interestRateFixedRateRule;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected NotionalAmountLeg1 notionalAmountLeg1;
	@Inject protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
	@Inject protected NotionalCurrencyLeg1Rule notionalCurrencyLeg1Rule;
	@Inject protected NotionalQuantityScheduleLeg1Rule notionalQuantityScheduleLeg1Rule;
	@Inject protected PayoutFromProductLeg1Rule payoutFromProductLeg1Rule;
	@Inject protected PeriodicPaymentRule periodicPaymentRule;
	@Inject protected PriceFormatFromNotation priceFormatFromNotation;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;
	@Inject protected QuantityUnitOfMeasureLeg1Rule quantityUnitOfMeasureLeg1Rule;
	@Inject protected SettlementCurrencyRule settlementCurrencyRule;
	@Inject protected SettlementTermsLeg1 settlementTermsLeg1;
	@Inject protected SpreadCurrencyRule spreadCurrencyRule;
	@Inject protected SpreadValueRule spreadValueRule;
	@Inject protected TotalNotionalQuantityLeg1 totalNotionalQuantityLeg1;

	/**
	* @param transaction 
	* @param spreadNotation 
	* @param defaultValue 
	* @return leg 
	*/
	public Leg evaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
		Leg.LegBuilder legBuilder = doEvaluate(transaction, spreadNotation, defaultValue);
		
		final Leg leg;
		if (legBuilder == null) {
			leg = null;
		} else {
			leg = legBuilder.build();
			objectValidator.validate(Leg.class, leg);
		}
		
		return leg;
	}

	protected abstract Leg.LegBuilder doEvaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue);

	public static class Leg1Default extends Leg1 {
		@Override
		protected Leg.LegBuilder doEvaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
			Leg.LegBuilder leg = Leg.builder();
			return assignOutput(leg, transaction, spreadNotation, defaultValue);
		}
		
		protected Leg.LegBuilder assignOutput(Leg.LegBuilder leg, TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
			leg = toBuilder(MapperS.of(transaction)
				.mapSingleToItem(item -> {
					final MapperS<Product> thenArg0 = item
						.mapSingleToItem(_item -> MapperS.of(productForEvent.evaluate(_item.get())));
					final MapperS<Product> thenArg1 = thenArg0
						.mapSingleToItem(_item -> MapperS.of(productOrUnderlierProduct.evaluate(_item.get())));
					final MapperS<Product> thenArg2 = item
						.mapSingleToItem(_item -> MapperS.of(productForEvent.evaluate(_item.get())));
					final MapperS<SettlementTerms> thenArg3 = thenArg2
						.mapSingleToItem(_item -> MapperS.of(settlementTermsLeg1.evaluate(_item.get())));
					return MapperS.of(Leg.builder()
						.setPeriodicPayment(periodicPaymentRule.evaluate(interestRateLeg1.evaluate(productOrUnderlierProduct.evaluate(productForEvent.evaluate(item.get())))))
						.setFixedRate(MapperS.of(interestRateFixedRateRule.evaluate(interestRateLeg1.evaluate(thenArg1.get()))).get())
						.setNotionalAmount(notionalAmountLeg1.evaluate(transaction, defaultValue))
						.setNotionalCurrency(notionalCurrencyLeg1Rule.evaluate(item.get()))
						.setTotalNotionalQuantity(totalNotionalQuantityLeg1.evaluate(transaction, defaultValue))
						.setNotionalAmountSchedule(new ArrayList(notionalAmountScheduleLeg1Rule.evaluate(item.get())))
						.setNotionalQuantitySchedule(new ArrayList(notionalQuantityScheduleLeg1Rule.evaluate(item.get())))
						.setSettlementCurrency(thenArg3
							.mapSingleToItem(_item -> MapperS.of(settlementCurrencyRule.evaluate(_item.get()))).get())
						.setSpread(item
							.mapSingleToItem(_item -> MapperS.of(priceFormatFromNotation.evaluate(spreadValueRule.evaluate(payoutFromProductLeg1Rule.evaluate(_item.get())), spreadNotation))).get())
						.setSpreadNotation(spreadNotation)
						.setSpreadCurrency(spreadCurrencyRule.evaluate(payoutFromProductLeg1Rule.evaluate(item.get())))
						.setQuantityUnitOfMeasure(quantityUnitOfMeasureLeg1Rule.evaluate(item.get()))
						.setDirection2(direction2Leg1Rule.evaluate(item.get()))
						.build());
				}).get());
			
			return Optional.ofNullable(leg)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
