package drr.standards.iosco.cde.version3.quantity.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.common.TransactionReportInstruction;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(ExtractPutAmount.ExtractPutAmountDefault.class)
public abstract class ExtractPutAmount implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version2.quantity.functions.ExtractPutAmount extractPutAmount;

	/**
	* @param transactionReportInstruction 
	* @param defaultValue 
	* @return putAmount 
	*/
	public BigDecimal evaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
		BigDecimal putAmount = doEvaluate(transactionReportInstruction, defaultValue);
		
		return putAmount;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue);

	public static class ExtractPutAmountDefault extends ExtractPutAmount {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			BigDecimal putAmount = null;
			return assignOutput(putAmount, transactionReportInstruction, defaultValue);
		}
		
		protected BigDecimal assignOutput(BigDecimal putAmount, TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			putAmount = extractPutAmount.evaluate(transactionReportInstruction, defaultValue);
			
			return putAmount;
		}
	}
}
