package drr.standards.iosco.cde.version3.underlier.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.GetOtherUnderlierLeg1;
import drr.regulation.common.functions.GetUnderlierProductIdentifierLeg1;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(UnderlierIDOtherLeg1Rule.UnderlierIDOtherLeg1RuleDefault.class)
public abstract class UnderlierIDOtherLeg1Rule implements ReportFunction<ReportableEvent, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetOtherUnderlierLeg1 getOtherUnderlierLeg1;
	@Inject protected GetUnderlierProductIdentifierLeg1 getUnderlierProductIdentifierLeg1;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(ReportableEvent input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(ReportableEvent input);

	public static class UnderlierIDOtherLeg1RuleDefault extends UnderlierIDOtherLeg1Rule {
		@Override
		protected String doEvaluate(ReportableEvent input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, ReportableEvent input) {
			final MapperS<Product> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			output = thenArg
				.mapSingleToItem(item -> {
					if (exists(MapperC.<ProductIdentifier>of(getUnderlierProductIdentifierLeg1.evaluate(item.get()))).and(notEqual(MapperC.<ProductIdentifier>of(getUnderlierProductIdentifierLeg1.evaluate(item.get())).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.All)).getOrDefault(false)) {
						return MapperC.<ProductIdentifier>of(getUnderlierProductIdentifierLeg1.evaluate(item.get()))
							.first().<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue());
					}
					if (exists(MapperS.of(getOtherUnderlierLeg1.evaluate(item.get()))).getOrDefault(false)) {
						return MapperS.of(getOtherUnderlierLeg1.evaluate(item.get()));
					}
					return MapperS.<String>ofNull();
				}).get();
			
			return output;
		}
	}
}
