package drr.standards.iosco.cde.version3.underlier.reports;

import cdm.base.staticdata.asset.common.IndexReferenceInformation;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.CreditIndexReferenceInformation;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.RateSpecification;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.qualification.product.functions.IsFXForward;
import drr.base.qualification.product.functions.IsFXOption;
import drr.base.qualification.product.functions.IsFXSwap;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.GetUnderlierProductIdentifierLeg2;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsFRA;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(UnderlierIDOtherSourceLeg2Rule.UnderlierIDOtherSourceLeg2RuleDefault.class)
public abstract class UnderlierIDOtherSourceLeg2Rule implements ReportFunction<ReportableEvent, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected GetUnderlierProductIdentifierLeg2 getUnderlierProductIdentifierLeg2;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsFRA isFRA;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXOption isFXOption;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(ReportableEvent input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(ReportableEvent input);

	public static class UnderlierIDOtherSourceLeg2RuleDefault extends UnderlierIDOtherSourceLeg2Rule {
		@Override
		protected String doEvaluate(ReportableEvent input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, ReportableEvent input) {
			final MapperS<Product> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			output = thenArg
				.mapSingleToItem(item -> {
					if (exists(MapperC.<ProductIdentifier>of(getUnderlierProductIdentifierLeg2.evaluate(item.get()))).and(notEqual(MapperC.<ProductIdentifier>of(getUnderlierProductIdentifierLeg2.evaluate(item.get())).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.All)).getOrDefault(false)) {
						return MapperC.<ProductIdentifier>of(getUnderlierProductIdentifierLeg2.evaluate(item.get()))
							.first().<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()).map("to-string", ProductIdTypeEnum::toDisplayString);
					}
					if (exists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation())).and(notExists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).<FieldWithMetaString>mapC("getIndexId", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexId()))).and(exists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName()))).or(exists(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation())).and(notExists(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).<FieldWithMetaString>mapC("getIndexId", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexId()))).and(exists(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName())))).or(ComparisonResult.of(MapperS.of(isFRA.evaluate(item.get()))).and(notExists(MapperS.of(interestRateLeg2.evaluate(item.get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption0 -> referenceWithMetaFloatingRateOption0 == null ? null : referenceWithMetaFloatingRateOption0.getValue()).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<FieldWithMetaString>mapC("getIndexId", indexReferenceInformation -> indexReferenceInformation.getIndexId()))).and(exists(MapperS.of(interestRateLeg2.evaluate(item.get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption1 -> referenceWithMetaFloatingRateOption1 == null ? null : referenceWithMetaFloatingRateOption1.getValue()).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", indexReferenceInformation -> indexReferenceInformation.getIndexName())))).getOrDefault(false)) {
						return MapperS.of(ProductIdTypeEnum.NAME).map("to-string", ProductIdTypeEnum::toDisplayString);
					}
					if (ComparisonResult.of(MapperS.of(isFXForward.evaluate(item.get()))).or(ComparisonResult.of(MapperS.of(isFXOption.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isFXSwap.evaluate(item.get())))).getOrDefault(false)) {
						return MapperS.of("CCY");
					}
					return MapperS.<String>ofNull();
				}).get();
			
			return output;
		}
	}
}
