/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxMatrixBuilder;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.tuple.Pair;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class FxMatrix
implements FxRateProvider,
ImmutableBean,
Serializable {
    private static final FxMatrix EMPTY = FxMatrix.builder().build();
    @PropertyDefinition(validate="notNull", get="")
    private final ImmutableMap<Currency, Integer> currencies;
    @PropertyDefinition(validate="notNull")
    private final DoubleMatrix rates;
    private static final long serialVersionUID = 1L;

    public static FxMatrix empty() {
        return EMPTY;
    }

    public static FxMatrix of(CurrencyPair currencyPair, double rate) {
        return FxMatrix.of(currencyPair.getBase(), currencyPair.getCounter(), rate);
    }

    public static FxMatrix of(Currency ccy1, Currency ccy2, double rate) {
        return new FxMatrixBuilder().addRate(ccy1, ccy2, rate).build();
    }

    public static FxMatrixBuilder builder() {
        return new FxMatrixBuilder();
    }

    public static Collector<? super Map.Entry<CurrencyPair, Double>, FxMatrixBuilder, FxMatrix> entriesToFxMatrix() {
        return FxMatrix.collector((builder, entry) -> builder.addRate((CurrencyPair)entry.getKey(), (Double)entry.getValue()));
    }

    public static Collector<? super Pair<CurrencyPair, Double>, FxMatrixBuilder, FxMatrix> pairsToFxMatrix() {
        return FxMatrix.collector((builder, pair) -> builder.addRate((CurrencyPair)pair.getFirst(), (Double)pair.getSecond()));
    }

    private static <T> Collector<T, FxMatrixBuilder, FxMatrix> collector(BiConsumer<FxMatrixBuilder, T> accumulator) {
        return Collector.of(FxMatrix::builder, accumulator, FxMatrixBuilder::merge, FxMatrixBuilder::build, new Collector.Characteristics[0]);
    }

    public ImmutableSet<Currency> getCurrencies() {
        return this.currencies.keySet();
    }

    @Override
    public double fxRate(Currency baseCurrency, Currency counterCurrency) {
        if (baseCurrency.equals(counterCurrency)) {
            return 1.0;
        }
        Integer index1 = (Integer)this.currencies.get((Object)baseCurrency);
        Integer index2 = (Integer)this.currencies.get((Object)counterCurrency);
        if (index1 != null && index2 != null) {
            return this.rates.get(index1.intValue(), index2.intValue());
        }
        throw new IllegalArgumentException(Messages.format((String)"No FX rate found for {}/{}, matrix only contains rates for {}", (Object[])new Object[]{baseCurrency, counterCurrency, this.currencies.keySet()}));
    }

    public CurrencyAmount convert(CurrencyAmount amount, Currency targetCurrency) {
        ArgChecker.notNull((Object)amount, (String)"amount");
        ArgChecker.notNull((Object)targetCurrency, (String)"targetCurrency");
        Currency originalCurrency = amount.getCurrency();
        if (originalCurrency.equals(targetCurrency)) {
            return amount;
        }
        return CurrencyAmount.of(targetCurrency, this.convert(amount.getAmount(), originalCurrency, targetCurrency));
    }

    public CurrencyAmount convert(MultiCurrencyAmount amount, Currency targetCurrency) {
        ArgChecker.notNull((Object)amount, (String)"amount");
        ArgChecker.notNull((Object)targetCurrency, (String)"targetCurrency");
        double total = amount.getAmounts().stream().mapToDouble(ca -> this.convert(ca.getAmount(), ca.getCurrency(), targetCurrency)).sum();
        return CurrencyAmount.of(targetCurrency, total);
    }

    public FxMatrix merge(FxMatrix other) {
        return this.toBuilder().merge(other.toBuilder()).build();
    }

    public FxMatrixBuilder toBuilder() {
        return new FxMatrixBuilder(this.currencies, this.rates.toArray());
    }

    public String toString() {
        return "FxMatrix[" + Joiner.on((String)", ").join(this.getCurrencies()) + " : " + Stream.of(this.rates.toArrayUnsafe()).map(Arrays::toString).collect(Collectors.joining(",")) + "]";
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    FxMatrix(Map<Currency, Integer> currencies, DoubleMatrix rates) {
        JodaBeanUtils.notNull(currencies, (String)"currencies");
        JodaBeanUtils.notNull((Object)rates, (String)"rates");
        this.currencies = ImmutableMap.copyOf(currencies);
        this.rates = rates;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public DoubleMatrix getRates() {
        return this.rates;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxMatrix other = (FxMatrix)obj;
            return JodaBeanUtils.equal(this.currencies, other.currencies) && JodaBeanUtils.equal((Object)this.rates, (Object)other.rates);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.currencies);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rates);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FxMatrix> {
        private Map<Currency, Integer> currencies = ImmutableMap.of();
        private DoubleMatrix rates;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1089470353: {
                    return this.currencies;
                }
                case 108285843: {
                    return this.rates;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1089470353: {
                    this.currencies = (Map)newValue;
                    break;
                }
                case 108285843: {
                    this.rates = (DoubleMatrix)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FxMatrix build() {
            return new FxMatrix(this.currencies, this.rates);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("FxMatrix.Builder{");
            buf.append("currencies").append('=').append(JodaBeanUtils.toString(this.currencies)).append(',').append(' ');
            buf.append("rates").append('=').append(JodaBeanUtils.toString((Object)this.rates));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableMap<Currency, Integer>> currencies = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencies", FxMatrix.class, ImmutableMap.class);
        private final MetaProperty<DoubleMatrix> rates = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rates", FxMatrix.class, DoubleMatrix.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currencies", "rates"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1089470353: {
                    return this.currencies;
                }
                case 108285843: {
                    return this.rates;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FxMatrix> builder() {
            return new Builder();
        }

        public Class<? extends FxMatrix> beanType() {
            return FxMatrix.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableMap<Currency, Integer>> currencies() {
            return this.currencies;
        }

        public MetaProperty<DoubleMatrix> rates() {
            return this.rates;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1089470353: {
                    return ((FxMatrix)bean).currencies;
                }
                case 108285843: {
                    return ((FxMatrix)bean).getRates();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

