/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.ReferenceDataId;
import com.opengamma.strata.basics.ReferenceDataNotFoundException;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import com.opengamma.strata.basics.date.HolidayCalendarIniLookup;
import com.opengamma.strata.basics.date.HolidayCalendars;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.named.Named;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class HolidayCalendarId
implements ReferenceDataId<HolidayCalendar>,
Resolvable<HolidayCalendar>,
Named,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ConcurrentHashMap<String, HolidayCalendarId> CACHE = new ConcurrentHashMap();
    private final String name;
    private final transient int hashCode;
    private final transient BiFunction<HolidayCalendarId, ReferenceData, HolidayCalendar> resolver;

    @FromString
    public static HolidayCalendarId of(String uniqueName) {
        HolidayCalendarId id = CACHE.get(uniqueName);
        return id != null ? id : HolidayCalendarId.create(uniqueName);
    }

    private static HolidayCalendarId create(String name) {
        if (!name.contains("+")) {
            return CACHE.computeIfAbsent(name, n -> new HolidayCalendarId(name));
        }
        List ids = Splitter.on((char)'+').splitToList((CharSequence)name).stream().filter(n -> !n.equals(HolidayCalendarIds.NO_HOLIDAYS.getName())).map(n -> HolidayCalendarId.of(n)).distinct().sorted(Comparator.comparing(HolidayCalendarId::getName)).collect(Collectors.toList());
        String normalizedName = Joiner.on((char)'+').join(ids);
        BiFunction<HolidayCalendarId, ReferenceData, HolidayCalendar> resolver = (id, refData) -> {
            HolidayCalendar cal = refData.queryValueOrNull(id);
            if (cal != null) {
                return cal;
            }
            cal = HolidayCalendars.NO_HOLIDAYS;
            for (HolidayCalendarId splitId : ids) {
                HolidayCalendar splitCal = refData.queryValueOrNull(splitId);
                if (splitCal == null) {
                    throw new ReferenceDataNotFoundException(Messages.format((String)"Reference data not found for '{}' of type 'HolidayCalendarId' when finding '{}'", (Object[])new Object[]{splitId, id}));
                }
                cal = cal.combinedWith(splitCal);
            }
            return cal;
        };
        HolidayCalendarId id2 = CACHE.computeIfAbsent(normalizedName, n -> new HolidayCalendarId(normalizedName, resolver));
        CACHE.putIfAbsent(name, id2);
        return id2;
    }

    public static HolidayCalendarId defaultByCurrency(Currency currency) {
        return HolidayCalendarIniLookup.INSTANCE.defaltByCurrency(currency);
    }

    private HolidayCalendarId(String normalizedName) {
        this.name = normalizedName;
        this.hashCode = normalizedName.hashCode();
        this.resolver = (id, refData) -> refData.queryValueOrNull(this);
    }

    private HolidayCalendarId(String normalizedName, BiFunction<HolidayCalendarId, ReferenceData, HolidayCalendar> resolver) {
        this.name = normalizedName;
        this.hashCode = normalizedName.hashCode();
        this.resolver = resolver;
    }

    private Object readResolve() {
        return HolidayCalendarId.of(this.name);
    }

    @ToString
    public String getName() {
        return this.name;
    }

    @Override
    public Class<HolidayCalendar> getReferenceDataType() {
        return HolidayCalendar.class;
    }

    @Override
    public HolidayCalendar resolve(ReferenceData refData) {
        return refData.getValue(this);
    }

    @Override
    public HolidayCalendar queryValueOrNull(ReferenceData refData) {
        return this.resolver.apply(this, refData);
    }

    public HolidayCalendarId combinedWith(HolidayCalendarId other) {
        if (this == other) {
            return this;
        }
        if (this == HolidayCalendarIds.NO_HOLIDAYS) {
            return (HolidayCalendarId)ArgChecker.notNull((Object)other, (String)"other");
        }
        if (other == HolidayCalendarIds.NO_HOLIDAYS) {
            return this;
        }
        return HolidayCalendarId.of(this.name + '+' + other.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HolidayCalendarId that = (HolidayCalendarId)obj;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.name;
    }
}

