/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IndexObservation;
import com.opengamma.strata.basics.index.PriceIndex;
import java.io.Serializable;
import java.time.YearMonth;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class PriceIndexObservation
implements IndexObservation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PriceIndex index;
    @PropertyDefinition(validate="notNull")
    private final YearMonth fixingMonth;
    private static final long serialVersionUID = 1L;

    public static PriceIndexObservation of(PriceIndex index, YearMonth fixingMonth) {
        return new PriceIndexObservation(index, fixingMonth);
    }

    public Currency getCurrency() {
        return this.index.getCurrency();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            PriceIndexObservation other = (PriceIndexObservation)obj;
            return this.index.equals(other.index) && this.fixingMonth.equals(other.fixingMonth);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + this.index.hashCode();
        return hash * 31 + this.fixingMonth.hashCode();
    }

    public String toString() {
        return new StringBuilder(64).append("PriceIndexObservation[").append(this.index).append(" on ").append(this.fixingMonth).append(']').toString();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private PriceIndexObservation(PriceIndex index, YearMonth fixingMonth) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)fixingMonth, (String)"fixingMonth");
        this.index = index;
        this.fixingMonth = fixingMonth;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public PriceIndex getIndex() {
        return this.index;
    }

    public YearMonth getFixingMonth() {
        return this.fixingMonth;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<PriceIndexObservation> {
        private PriceIndex index;
        private YearMonth fixingMonth;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 265281235: {
                    return this.fixingMonth;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (PriceIndex)newValue;
                    break;
                }
                case 265281235: {
                    this.fixingMonth = (YearMonth)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public PriceIndexObservation build() {
            return new PriceIndexObservation(this.index, this.fixingMonth);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("PriceIndexObservation.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("fixingMonth").append('=').append(JodaBeanUtils.toString((Object)this.fixingMonth));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PriceIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", PriceIndexObservation.class, PriceIndex.class);
        private final MetaProperty<YearMonth> fixingMonth = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingMonth", PriceIndexObservation.class, YearMonth.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "fixingMonth"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 265281235: {
                    return this.fixingMonth;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends PriceIndexObservation> builder() {
            return new Builder();
        }

        public Class<? extends PriceIndexObservation> beanType() {
            return PriceIndexObservation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PriceIndex> index() {
            return this.index;
        }

        public MetaProperty<YearMonth> fixingMonth() {
            return this.fixingMonth;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((PriceIndexObservation)bean).getIndex();
                }
                case 265281235: {
                    return ((PriceIndexObservation)bean).getFixingMonth();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

