/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.xcore.compressor;

import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.regnosys.rosetta.xcore.compressor.IfElseCascade;
import com.regnosys.rosetta.xcore.compressor.IfElseCascadeParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;

public class ParserCompressorFragment
extends AbstractXtextGeneratorFragment {
    private static final Logger LOGGER = Logger.getLogger(ParserCompressorFragment.class);
    static final Pattern CONST_DEF_PATTERN = Pattern.compile("^\\s*public\\ static\\ final\\ int\\ ([A-Za-z_0-9]+)=(-?[0-9]+);$", 8);
    static final Pattern STATE_CHANGE_INITIALIZER_PATTERN = Pattern.compile("^\\s+s\\ =\\ -1;$", 8);
    private final List<String> grammarFiles = new ArrayList<String>();
    private boolean backup = false;
    private int cascadeThreshold = 10;
    private boolean uglifyAndJoinLinesEagerly;

    public void addGrammarFile(String fileName) {
        this.grammarFiles.add(fileName);
    }

    public void setJoinLinesEagerly(boolean joinLines) {
        this.uglifyAndJoinLinesEagerly = joinLines;
    }

    public void generate() {
        for (String fileName : this.grammarFiles) {
            File file = new File(fileName);
            String javaSource = null;
            try {
                javaSource = Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read();
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Error reading file " + fileName + ": " + ex.getMessage()));
            }
            if (javaSource == null) continue;
            String compressed = this.process(javaSource, file);
            LOGGER.info((Object)("File " + this.readableFileName(file) + " compressed: " + javaSource.length() + " --> " + compressed.length() + " (" + 100 * compressed.length() / javaSource.length() + "%)"));
            if (this.backup) {
                try {
                    Files.copy((File)file, (File)new File(file.getParentFile(), file.getName() + ".bak"));
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Error creating backup of " + this.readableFileName(file) + ": " + e.getMessage()));
                    return;
                }
            }
            try {
                Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)compressed);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error writing compressed file " + this.readableFileName(file) + ": " + e.getMessage()));
            }
        }
    }

    String readableFileName(File f) {
        int firstSeg;
        int firstChar;
        String path = f.getPath();
        for (firstChar = 0; firstChar < path.length() && !Character.isLetterOrDigit(path.charAt(firstChar)); ++firstChar) {
        }
        if (firstChar == path.length()) {
            firstChar = 0;
        }
        if ((firstSeg = path.indexOf(File.separatorChar, firstChar)) > 0) {
            return path.substring(firstChar, firstSeg) + "/.../" + f.getName();
        }
        return f.getName();
    }

    String process(String javaSource, File file) {
        Map<String, Integer> parserConstMap = this.createConstMap(javaSource);
        if (parserConstMap.isEmpty()) {
            LOGGER.info((Object)("No integer constants found in " + this.readableFileName(file)));
            return null;
        }
        String result = this.processCascades(javaSource, parserConstMap);
        if (this.uglifyAndJoinLinesEagerly && (result = Pattern.compile("(\r?\n)\\s*\r?\n", 40).matcher(result).replaceAll("$1")).indexOf("restoreStackSize(stackSize);") > 0) {
            result = result.replace("catch (RecognitionException re) {\n            reportError(re);\n            recover(input,re);\n        }\n        finally {\n            \trestoreStackSize(stackSize);\n        }\n        return ;", "catch (RecognitionException re) { reportError(re); recover(input,re); } finally { restoreStackSize(stackSize); }");
            result = result.replace("catch (RecognitionException re) {\n            reportError(re);\n            recover(input,re);\n        }\n        finally {\n        }\n        return ;", "catch (RecognitionException re) { reportError(re); recover(input,re); }");
            result = result.replace("if ( state.backtracking==0 ) {\n               before", "if ( state.backtracking==0 ) { before");
            result = result.replace("if ( state.backtracking==0 ) {\n               after", "if ( state.backtracking==0 ) { after");
            result = result.replace("()); \n            }", "()); }");
            result = result.replace("state._fsp--;\n            if (state.failed) return ;", "state._fsp--; if (state.failed) return ;");
            result = result.replace("{\n            {", "{{");
            result = result.replace("{\n            {", "{{");
            result = result.replace("{\n            {", "{{");
            result = result.replace("}\n            }", "}}");
            result = result.replace("}\n            }", "}}");
            result = result.replace("}\n            }", "}}");
            result = result.replace(";\n        state._fsp--;\n        if (state.failed) return ;", "; state._fsp--; if (state.failed) return ;");
            result = result.replace(";\n            state._fsp--; if (state.failed) return ;", "; state._fsp--; if (state.failed) return ;");
            result = result.replace("}\n        catch (RecognitionException re)", "} catch (RecognitionException re)");
            result = result.replace("{\n        \t\tint stackSize = keepStackSize();", "{ int stackSize = keepStackSize();");
            result = result.replace("}\n        catch", "} catch");
        }
        return result;
    }

    String processCascades(String javaSource, Map<String, Integer> parserConstMap) {
        List<IfElseCascade> cascades = this.findCascades(javaSource);
        if (cascades.isEmpty()) {
            return javaSource;
        }
        StringBuilder strb = new StringBuilder(javaSource.length());
        int offset = 0;
        int counter = 0;
        ArrayList<String> transMatrixDefs = new ArrayList<String>(cascades.size());
        HashMap<String, String> arrayLiterals = new HashMap<String, String>();
        for (IfElseCascade cascade : cascades) {
            if (cascade.size() < this.cascadeThreshold) continue;
            strb.append(javaSource.substring(offset, cascade.start));
            IfElseCascade.Replacement replacements = cascade.getReplacements(parserConstMap, counter);
            String delegate = (String)arrayLiterals.get(replacements.arrayLiteral);
            strb.append("\n                        ");
            if (delegate == null) {
                transMatrixDefs.add(replacements.getMatrixDefinition());
                arrayLiterals.put(replacements.arrayLiteral, IfElseCascade.getMatrixName(counter));
                strb.append(replacements.getStatement());
            } else {
                strb.append(replacements.getStatement(delegate));
            }
            strb.append("\n                        ");
            offset = cascade.end;
            ++counter;
        }
        strb.append(javaSource.substring(offset, javaSource.length()));
        strb.append("\nfinal class ").append("T2S").append("{");
        for (String def : transMatrixDefs) {
            strb.append("\n\t").append(def);
        }
        strb.append("\n}");
        String compressed = strb.toString();
        return compressed;
    }

    private List<IfElseCascade> findCascades(String grammarContent) {
        Matcher matcher = STATE_CHANGE_INITIALIZER_PATTERN.matcher(grammarContent);
        IfElseCascadeParser ifElseCascadeParser = new IfElseCascadeParser(grammarContent);
        ArrayList<IfElseCascade> cascades = new ArrayList<IfElseCascade>();
        int cascadeEnd = 0;
        while (matcher.find()) {
            int offset = matcher.end();
            if (offset < cascadeEnd) {
                throw new IllegalStateException("New state initializer in cascade found");
            }
            List<IfElseCascade> moreCascades = ifElseCascadeParser.findCascades(offset);
            if (moreCascades == null) continue;
            cascades.addAll(moreCascades);
        }
        return cascades;
    }

    Map<String, Integer> createConstMap(String grammarContent) {
        HashMap<String, Integer> parserConstMap = new HashMap<String, Integer>();
        Matcher matcher = CONST_DEF_PATTERN.matcher(grammarContent);
        while (matcher.find()) {
            String name = matcher.group(1);
            int value = Integer.parseInt(matcher.group(2));
            parserConstMap.put(name, value);
        }
        return parserConstMap;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public void setCascadeThreshold(String cascadeThreshold) {
        this.cascadeThreshold = Integer.parseInt(cascadeThreshold);
    }
}

