/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.interpreter;

import com.regnosys.rosetta.interpreter.RosettaInterpreterTypeException;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.interpreter.RosettaValueWithNaturalOrder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;

public abstract class AbstractRosettaValue<T>
implements RosettaValue {
    private List<T> items;

    public AbstractRosettaValue(List<T> items) {
        Validate.noNullElements(items);
        this.items = items;
    }

    public List<T> getItems() {
        return this.items;
    }

    @Override
    public <U> List<U> getItems(Class<U> clazz) {
        if (this.items.stream().anyMatch(i -> !clazz.isInstance(i))) {
            throw new RosettaInterpreterTypeException(String.valueOf(this.items) + " is not of type " + String.valueOf(clazz));
        }
        return this.items.stream().map(i -> clazz.cast(i)).collect(Collectors.toList());
    }

    @Override
    public RosettaValueWithNaturalOrder<?> withNaturalOrderOrThrow() {
        throw new RosettaInterpreterTypeException("Rosetta value " + String.valueOf(this) + " does not have a natural order.");
    }

    @Override
    public int size() {
        return this.items.size();
    }

    public Stream<T> stream() {
        return this.items.stream();
    }

    public Optional<T> getSingle() {
        if (this.items.size() == 1) {
            return Optional.of(this.items.get(0));
        }
        return Optional.empty();
    }

    public T getSingleOrThrow() {
        return this.getSingle().orElseThrow(() -> new RosettaInterpreterTypeException("Expected a single item, but got " + String.valueOf(this) + "."));
    }

    @Override
    public <U> Optional<U> getSingle(Class<U> clazz) {
        return this.getSingle().filter(v -> clazz.isInstance(v)).map(v -> clazz.cast(v));
    }

    @Override
    public <U> U getSingleOrThrow(Class<U> clazz) {
        T v = this.getSingleOrThrow();
        if (clazz.isInstance(v)) {
            return clazz.cast(v);
        }
        throw new RosettaInterpreterTypeException("Expected a single item of type " + clazz.getSimpleName() + ", but got " + String.valueOf(this) + ".");
    }

    public String toString() {
        return "[" + this.items.stream().map(i -> i.toString()).collect(Collectors.joining(", ")) + "]";
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RosettaValue)) {
            return false;
        }
        RosettaValue other = (RosettaValue)object;
        return Objects.equals(this.items, other.getItems());
    }
}

