/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.rules;

import com.regnosys.rosetta.rules.RuleResult;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RulePathMap {
    private final RulePathMap parentInContext;
    private final List<RulePathMap> parentsOutsideContext;
    private final Map<List<String>, RuleResult> map = new LinkedHashMap<List<String>, RuleResult>();
    private final String id;

    public RulePathMap(String id, RulePathMap parentInContext, List<RulePathMap> parentsOutsideContextInDescendingPriority) {
        this.parentInContext = parentInContext;
        this.parentsOutsideContext = parentsOutsideContextInDescendingPriority;
        this.id = id;
    }

    public void add(List<String> path, RuleResult ruleResult) {
        this.map.put(path, ruleResult);
    }

    public RuleResult get(List<String> path) {
        RuleResult result = this.getInContext(path);
        if (result != null) {
            return result;
        }
        for (RulePathMap parent : this.parentsOutsideContext) {
            result = parent.get(path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private RuleResult getInContext(List<String> path) {
        RuleResult result = this.map.get(path);
        if (result != null) {
            return result;
        }
        if (this.parentInContext != null) {
            result = this.parentInContext.getInContext(path);
        }
        return result;
    }

    public Map<List<String>, RuleResult> getAsMap() {
        LinkedHashMap<List<String>, RuleResult> result = new LinkedHashMap<List<String>, RuleResult>();
        this.addRulesToMapIfNotPresent(result);
        return result;
    }

    public void addRulesToMapIfNotPresent(Map<List<String>, RuleResult> mapToAddTo) {
        this.addRulesInContextToMapIfNotPresent(mapToAddTo);
        for (RulePathMap parent : this.parentsOutsideContext) {
            parent.addRulesToMapIfNotPresent(mapToAddTo);
        }
    }

    private void addRulesInContextToMapIfNotPresent(Map<List<String>, RuleResult> mapToAddTo) {
        this.map.forEach(mapToAddTo::putIfAbsent);
        if (this.parentInContext != null) {
            this.parentInContext.addRulesInContextToMapIfNotPresent(mapToAddTo);
        }
    }

    public Map<List<String>, RuleResult> getInheritedRules() {
        Map<List<String>, RuleResult> result = this.getParentRules();
        result.keySet().removeAll(this.map.keySet());
        return result;
    }

    public Map<List<String>, RuleResult> getParentRules() {
        LinkedHashMap<List<String>, RuleResult> result = new LinkedHashMap<List<String>, RuleResult>();
        if (this.parentInContext != null) {
            this.parentInContext.addRulesInContextToMapIfNotPresent(result);
        }
        for (RulePathMap parent : this.parentsOutsideContext) {
            parent.addRulesToMapIfNotPresent(result);
        }
        return result;
    }

    public Map<List<String>, RuleResult> getOwnRules() {
        return this.map;
    }

    public String toString() {
        return "RulePathMap{parentsSize=" + ((this.parentInContext == null ? 0 : 1) + this.parentsOutsideContext.size()) + ", map=" + String.valueOf(this.map) + ", id='" + this.id + "'}";
    }
}

