/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.basket.functions;

import cdm.product.template.Basket;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetBasketDefault.class)
public abstract class GetBasket
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends Product> evaluate(Basket basket) {
        List basketConstituent;
        List<Product.ProductBuilder> basketConstituentBuilder = this.doEvaluate(basket);
        if (basketConstituentBuilder == null) {
            basketConstituent = null;
        } else {
            basketConstituent = basketConstituentBuilder.stream().map(Product::build).collect(Collectors.toList());
            this.objectValidator.validate(Product.class, basketConstituent);
        }
        return basketConstituent;
    }

    protected abstract List<Product.ProductBuilder> doEvaluate(Basket var1);

    public static class GetBasketDefault
    extends GetBasket {
        @Override
        protected List<Product.ProductBuilder> doEvaluate(Basket basket) {
            ArrayList<Product.ProductBuilder> basketConstituent = new ArrayList<Product.ProductBuilder>();
            return this.assignOutput(basketConstituent, basket);
        }

        protected List<Product.ProductBuilder> assignOutput(List<Product.ProductBuilder> basketConstituent, Basket basket) {
            basketConstituent = ExpressionOperators.exists((Mapper)MapperS.of((Object)basket).mapC("getBasketConstituent", _basket -> _basket.getBasketConstituent())).getOrDefault(Boolean.valueOf(false)) != false ? this.toBuilder(MapperS.of((Object)basket).mapC("getBasketConstituent", _basket -> _basket.getBasketConstituent()).getMulti()) : this.toBuilder(MapperS.of((Object)basket).mapC("getPortfolioBasketConstituent", _basket -> _basket.getPortfolioBasketConstituent()).getMulti());
            return Optional.ofNullable(basketConstituent).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

