/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.price.functions;

import cdm.observable.asset.PriceSchedule;
import cdm.product.template.CalculationSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.PricePeriod;
import drr.base.trade.price.functions.PriceFormatFromNotation;
import drr.base.util.datetime.functions.EnrichDatedValueWithEndDate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=ReportablePricePeriodDefault.class)
public abstract class ReportablePricePeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EnrichDatedValueWithEndDate enrichDatedValueWithEndDate;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;

    public List<? extends PricePeriod> evaluate(PriceSchedule priceSchedule, CalculationSchedule calculationSchedule, PriceNotationEnum notation) {
        List pricePeriod;
        List<PricePeriod.PricePeriodBuilder> pricePeriodBuilder = this.doEvaluate(priceSchedule, calculationSchedule, notation);
        if (pricePeriodBuilder == null) {
            pricePeriod = null;
        } else {
            pricePeriod = pricePeriodBuilder.stream().map(PricePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(PricePeriod.class, pricePeriod);
        }
        return pricePeriod;
    }

    protected abstract List<PricePeriod.PricePeriodBuilder> doEvaluate(PriceSchedule var1, CalculationSchedule var2, PriceNotationEnum var3);

    public static class ReportablePricePeriodDefault
    extends ReportablePricePeriod {
        @Override
        protected List<PricePeriod.PricePeriodBuilder> doEvaluate(PriceSchedule priceSchedule, CalculationSchedule calculationSchedule, PriceNotationEnum notation) {
            ArrayList<PricePeriod.PricePeriodBuilder> pricePeriod = new ArrayList<PricePeriod.PricePeriodBuilder>();
            return this.assignOutput(pricePeriod, priceSchedule, calculationSchedule, notation);
        }

        protected List<PricePeriod.PricePeriodBuilder> assignOutput(List<PricePeriod.PricePeriodBuilder> pricePeriod, PriceSchedule priceSchedule, CalculationSchedule calculationSchedule, PriceNotationEnum notation) {
            pricePeriod.addAll(this.toBuilder(MapperC.of(this.enrichDatedValueWithEndDate.evaluate(MapperS.of((Object)priceSchedule).mapC("getDatedValue", _priceSchedule -> _priceSchedule.getDatedValue()).getMulti(), calculationSchedule)).mapItem(item -> MapperS.of((Object)PricePeriod.builder().setPrice(this.priceFormatFromNotation.evaluate((BigDecimal)item.map("getValue", valuePeriod -> valuePeriod.getValue()).get(), notation)).setEffectiveDate((Date)item.map("getEffectiveDate", valuePeriod -> valuePeriod.getEffectiveDate()).get()).setEndDate((Date)item.map("getEndDate", valuePeriod -> valuePeriod.getEndDate()).get()).build())).getMulti()));
            return Optional.ofNullable(pricePeriod).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

