/*
 * Decompiled with CFR 0.152.
 */
package drr.base.util.datetime.functions;

import cdm.base.datetime.AdjustableDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.util.datetime.functions.AdjustableDateResolution;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=MinAdjustableDateResolutionDefault.class)
public abstract class MinAdjustableDateResolution
implements RosettaFunction {
    @Inject
    protected AdjustableDateResolution adjustableDateResolution;

    public Date evaluate(List<? extends AdjustableDate> adjustableDates) {
        Date date = this.doEvaluate(adjustableDates);
        return date;
    }

    protected abstract Date doEvaluate(List<? extends AdjustableDate> var1);

    public static class MinAdjustableDateResolutionDefault
    extends MinAdjustableDateResolution {
        @Override
        protected Date doEvaluate(List<? extends AdjustableDate> adjustableDates) {
            if (adjustableDates == null) {
                adjustableDates = Collections.emptyList();
            }
            Date date = null;
            return this.assignOutput(date, adjustableDates);
        }

        protected Date assignOutput(Date date, List<? extends AdjustableDate> adjustableDates) {
            MapperC thenArg = MapperC.of(adjustableDates).mapItem(item -> MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)item.get())));
            date = (Date)thenArg.min().get();
            return date;
        }
    }
}

