/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.common.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.EnrichmentData;
import drr.regulation.common.TransactionReportInstruction;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=EnrichmentDataRuleDefault.class)
public abstract class EnrichmentDataRule
implements ReportFunction<TransactionReportInstruction, EnrichmentData> {
    @Inject
    protected ModelObjectValidator objectValidator;

    public EnrichmentData evaluate(TransactionReportInstruction input) {
        EnrichmentData output;
        EnrichmentData.EnrichmentDataBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(EnrichmentData.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract EnrichmentData.EnrichmentDataBuilder doEvaluate(TransactionReportInstruction var1);

    public static class EnrichmentDataRuleDefault
    extends EnrichmentDataRule {
        @Override
        protected EnrichmentData.EnrichmentDataBuilder doEvaluate(TransactionReportInstruction input) {
            EnrichmentData.EnrichmentDataBuilder output = EnrichmentData.builder();
            return this.assignOutput(output, input);
        }

        protected EnrichmentData.EnrichmentDataBuilder assignOutput(EnrichmentData.EnrichmentDataBuilder output, TransactionReportInstruction input) {
            output = (EnrichmentData.EnrichmentDataBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)input).mapSingleToItem(item -> item.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).map("getEnrichment", reportableInformation -> reportableInformation.getEnrichment())).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

