/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.asic.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import iso20022.auth030.asic.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import iso20022.auth030.asic.AmountAndDirection106__1;
import iso20022.auth030.asic.PriceData2__1;
import iso20022.auth030.asic.SecuritiesTransactionPrice17Choice__1;
import iso20022.auth030.asic.UnitOfMeasure8Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetTxPricDefault.class)
public abstract class GetTxPric
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;

    public PriceData2__1 evaluate(ASICTransactionReport drrReport) {
        PriceData2__1 txPric;
        PriceData2__1.PriceData2__1Builder txPricBuilder = this.doEvaluate(drrReport);
        if (txPricBuilder == null) {
            txPric = null;
        } else {
            txPric = txPricBuilder.build();
            this.objectValidator.validate(PriceData2__1.class, (RosettaModelObject)txPric);
        }
        return txPric;
    }

    protected abstract PriceData2__1.PriceData2__1Builder doEvaluate(ASICTransactionReport var1);

    public static class GetTxPricDefault
    extends GetTxPric {
        @Override
        protected PriceData2__1.PriceData2__1Builder doEvaluate(ASICTransactionReport drrReport) {
            PriceData2__1.PriceData2__1Builder txPric = PriceData2__1.builder();
            return this.assignOutput(txPric, drrReport);
        }

        protected PriceData2__1.PriceData2__1Builder assignOutput(PriceData2__1.PriceData2__1Builder txPric, ASICTransactionReport drrReport) {
            txPric = (PriceData2__1.PriceData2__1Builder)this.toBuilder((RosettaModelObject)PriceData2__1.builder().setPric((SecuritiesTransactionPrice17Choice__1)MapperS.of((Object)drrReport).mapSingleToItem(item -> {
                Boolean ifThenElseResult = null;
                if (ExpressionOperators.lessThan((Mapper)item.map("getPrice", aSICTransactionReport -> aSICTransactionReport.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = false;
                }
                return MapperS.of((Object)SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getPrice", aSICTransactionReport -> aSICTransactionReport.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getPriceCurrency", aSICTransactionReport -> aSICTransactionReport.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult).build()).setDcml((BigDecimal)item.map("getPrice", aSICTransactionReport -> aSICTransactionReport.getPrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal()).get()).build());
            }).get()).setUnitOfMeasr(UnitOfMeasure8Choice__1.builder().setCd((String)MapperS.of((Object)drrReport).map("getPriceUnitOfMeasure", aSICTransactionReport -> aSICTransactionReport.getPriceUnitOfMeasure()).get()).build()).build());
            return Optional.ofNullable(txPric).map(o -> o.prune()).orElse(null);
        }
    }
}

