/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.hkma.rewrite.trade.dtcc.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport;

@ImplementedBy(value=GetFctvDtDefault.class)
public abstract class GetFctvDt
implements RosettaFunction {
    public Date evaluate(HKMATransactionReport drrReport) {
        Date fctvDt = this.doEvaluate(drrReport);
        return fctvDt;
    }

    protected abstract Date doEvaluate(HKMATransactionReport var1);

    public static class GetFctvDtDefault
    extends GetFctvDt {
        @Override
        protected Date doEvaluate(HKMATransactionReport drrReport) {
            Date fctvDt = null;
            return this.assignOutput(fctvDt, drrReport);
        }

        protected Date assignOutput(Date fctvDt, HKMATransactionReport drrReport) {
            fctvDt = (Date)MapperS.of((Object)drrReport).map("getEffectiveDate", hKMATransactionReport -> hKMATransactionReport.getEffectiveDate()).get();
            return fctvDt;
        }
    }
}

