/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.mas.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.util.string.functions.StringLength;
import drr.base.util.string.functions.SubString;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import iso20022.auth030.mas.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import iso20022.auth030.mas.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth030.mas.AmountAndDirection106__1;
import iso20022.auth030.mas.ExerciseDate1Choice__1;
import iso20022.auth030.mas.OptionOrSwaption11__1;
import iso20022.auth030.mas.OptionStyle6Code;
import iso20022.auth030.mas.OptionType2Code;
import iso20022.auth030.mas.Schedule4__1;
import iso20022.auth030.mas.SecuritiesTransactionPrice17Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetOptnDefault.class)
public abstract class GetOptn
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;
    @Inject
    protected StringLength stringLength;
    @Inject
    protected SubString subString;

    public OptionOrSwaption11__1 evaluate(MASTransactionReport drrReport) {
        OptionOrSwaption11__1 optn;
        OptionOrSwaption11__1.OptionOrSwaption11__1Builder optnBuilder = this.doEvaluate(drrReport);
        if (optnBuilder == null) {
            optn = null;
        } else {
            optn = optnBuilder.build();
            this.objectValidator.validate(OptionOrSwaption11__1.class, (RosettaModelObject)optn);
        }
        return optn;
    }

    protected abstract OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(MASTransactionReport var1);

    public static class GetOptnDefault
    extends GetOptn {
        @Override
        protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(MASTransactionReport drrReport) {
            OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn = OptionOrSwaption11__1.builder();
            return this.assignOutput(optn, drrReport);
        }

        protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder assignOutput(OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn, MASTransactionReport drrReport) {
            String ifThenElseResult = ExpressionOperators.exists((Mapper)MapperS.of((Object)drrReport).map("getOptionPremiumCurrency", mASTransactionReport -> mASTransactionReport.getOptionPremiumCurrency())).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)drrReport).map("getOptionPremiumCurrency", mASTransactionReport -> mASTransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getOptionPremiumAmount", mASTransactionReport -> mASTransactionReport.getOptionPremiumAmount()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)drrReport).map("getLeg1", mASTransactionReport -> mASTransactionReport.getLeg1()).map("getSettlementCurrency", commonLeg -> commonLeg.getSettlementCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get() : null);
            optn = (OptionOrSwaption11__1.OptionOrSwaption11__1Builder)this.toBuilder((RosettaModelObject)OptionOrSwaption11__1.builder().setTp((OptionType2Code)MapperS.of((Object)drrReport).map("getOptionType", mASTransactionReport -> mASTransactionReport.getOptionType()).checkedMap("to-enum", e -> OptionType2Code.valueOf((String)e.name()), IllegalArgumentException.class).get()).setExrcStyle((OptionStyle6Code)MapperS.of((Object)drrReport).map("getOptionStyle", mASTransactionReport -> mASTransactionReport.getOptionStyle()).checkedMap("to-enum", e -> OptionStyle6Code.valueOf((String)e.name()), IllegalArgumentException.class).get()).setExrcDt(ExerciseDate1Choice__1.builder().setFrstExrcDt((Date)MapperS.of((Object)drrReport).map("getFirstExerciseDate", mASTransactionReport -> mASTransactionReport.getFirstExerciseDate()).get()).build()).setStrkPric((SecuritiesTransactionPrice17Choice__1)MapperS.of((Object)drrReport).mapSingleToItem(item -> {
                String ifThenElseResult0 = null;
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", mASTransactionReport -> mASTransactionReport.getContractType()), (Mapper)MapperS.of((Object)((Object)CommonContractType.OPTN)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", mASTransactionReport -> mASTransactionReport.getContractType()), (Mapper)MapperS.of((Object)((Object)CommonContractType.SWPT)), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", mASTransactionReport -> mASTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.INTR)), (CardinalityOperator)CardinalityOperator.All), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult0 = ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)this.stringLength.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", mASTransactionReport -> mASTransactionReport.getStrikePriceCurrency()).get())), (Mapper)MapperS.of((Object)3), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", mASTransactionReport -> mASTransactionReport.getStrikePriceCurrency()).get(), 5, 3) : (String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", mASTransactionReport -> mASTransactionReport.getStrikePriceCurrency()).get();
                }
                Boolean ifThenElseResult1 = null;
                if (ExpressionOperators.lessThan((Mapper)item.map("getStrikePrice", mASTransactionReport -> mASTransactionReport.getStrikePrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult1 = false;
                }
                return MapperS.of((Object)SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getStrikePrice", mASTransactionReport -> mASTransactionReport.getStrikePrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())).setCcy(ifThenElseResult0).build()).setSgn(ifThenElseResult1).build()).setDcml((BigDecimal)item.map("getStrikePrice", mASTransactionReport -> mASTransactionReport.getStrikePrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal()).get()).build());
            }).get()).setStrkPricSchdl(MapperS.of((Object)drrReport).mapC("getStrikePriceSchedule", mASTransactionReport -> mASTransactionReport.getStrikePriceSchedule()).mapItem(item -> {
                AmountAndDirection106__1 ifThenElseResult2 = null;
                if (ExpressionOperators.exists((Mapper)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    String ifThenElseResult0 = null;
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", mASTransactionReport -> mASTransactionReport.getContractType()), (Mapper)MapperS.of((Object)((Object)CommonContractType.OPTN)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", mASTransactionReport -> mASTransactionReport.getContractType()), (Mapper)MapperS.of((Object)((Object)CommonContractType.SWPT)), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", mASTransactionReport -> mASTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.CURR)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", mASTransactionReport -> mASTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.INTR)), (CardinalityOperator)CardinalityOperator.All)), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult0 = (String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", mASTransactionReport -> mASTransactionReport.getStrikePriceCurrency()).map("to-string", Object::toString).get();
                    }
                    Boolean ifThenElseResult1 = null;
                    if (ExpressionOperators.lessThan((Mapper)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult1 = false;
                    }
                    ifThenElseResult2 = AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())).setCcy(ifThenElseResult0).build()).setSgn(ifThenElseResult1).build();
                }
                BigDecimal ifThenElseResult3 = null;
                if (ExpressionOperators.exists((Mapper)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult3 = (BigDecimal)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal()).get();
                }
                return MapperS.of((Object)Schedule4__1.builder().setUadjstdFctvDt((Date)item.map("getEffectiveDate", pricePeriod -> pricePeriod.getEffectiveDate()).get()).setUadjstdEndDt((Date)item.map("getEndDate", pricePeriod -> pricePeriod.getEndDate()).get()).setPric(SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(ifThenElseResult2).setDcml(ifThenElseResult3).build()).build());
            }).getMulti()).setCallAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getCallAmount", mASTransactionReport -> mASTransactionReport.getCallAmount()).get()).setCcy((String)MapperS.of((Object)drrReport).map("getCallCurrency", mASTransactionReport -> mASTransactionReport.getCallCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setPutAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getPutAmount", mASTransactionReport -> mASTransactionReport.getPutAmount()).get()).setCcy((String)MapperS.of((Object)drrReport).map("getPutCurrency", mASTransactionReport -> mASTransactionReport.getPutCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setPrmAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getOptionPremiumAmount", mASTransactionReport -> mASTransactionReport.getOptionPremiumAmount()).get()).setCcy(ifThenElseResult).build()).build());
            return Optional.ofNullable(optn).map(o -> o.prune()).orElse(null);
        }
    }
}

