/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.party.reports.BrokerIDRule;
import javax.inject.Inject;

@ImplementedBy(value=BrokerRuleDefault.class)
public abstract class BrokerRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected BrokerIDRule brokerIDRule;
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class BrokerRuleDefault
    extends BrokerRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEventBase)item.get()));
            output = (String)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.brokerIDRule.evaluate((TransactionReportInstruction)item.get()))).get();
            return output;
        }
    }
}

