/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.functions;

import cdm.base.staticdata.party.PartyRoleEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.util.party.functions.ExtractPartyFromRelatedPartyByRole;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

@ImplementedBy(value=PrimeBrokerageTransactionIndicatorFuncDefault.class)
public abstract class PrimeBrokerageTransactionIndicatorFunc
implements RosettaFunction {
    @Inject
    protected ExtractPartyFromRelatedPartyByRole extractPartyFromRelatedPartyByRole;

    public Boolean evaluate(TransactionReportInstruction transaction) {
        Boolean indicator = this.doEvaluate(transaction);
        return indicator;
    }

    protected abstract Boolean doEvaluate(TransactionReportInstruction var1);

    protected abstract MapperS<Boolean> primeBrokerExists(TransactionReportInstruction var1);

    protected abstract MapperC<? extends PartyInformation> executingBrokerPartyInfo(TransactionReportInstruction var1);

    protected abstract MapperC<Boolean> executingBrokerIsUSPerson(TransactionReportInstruction var1);

    public static class PrimeBrokerageTransactionIndicatorFuncDefault
    extends PrimeBrokerageTransactionIndicatorFunc {
        @Override
        protected Boolean doEvaluate(TransactionReportInstruction transaction) {
            Boolean indicator = null;
            return this.assignOutput(indicator, transaction);
        }

        protected Boolean assignOutput(Boolean indicator, TransactionReportInstruction transaction) {
            indicator = ComparisonResult.of(this.primeBrokerExists(transaction)).and(ComparisonResult.of(this.executingBrokerIsUSPerson(transaction))).get();
            return indicator;
        }

        @Override
        protected MapperS<Boolean> primeBrokerExists(TransactionReportInstruction transaction) {
            return ExpressionOperators.exists((Mapper)MapperS.of((Object)this.extractPartyFromRelatedPartyByRole.evaluate(MapperS.of((Object)transaction).map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.PRIME_BROKER))).asMapper();
        }

        @Override
        protected MapperC<? extends PartyInformation> executingBrokerPartyInfo(TransactionReportInstruction transaction) {
            return MapperS.of((Object)transaction).map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()), (Mapper)MapperS.of((Object)this.extractPartyFromRelatedPartyByRole.evaluate(item.mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.EXECUTING_BROKER)), (CardinalityOperator)CardinalityOperator.All).get());
        }

        @Override
        protected MapperC<Boolean> executingBrokerIsUSPerson(TransactionReportInstruction transaction) {
            return this.executingBrokerPartyInfo(transaction).mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).map("getCftcPartyInformation", reportingRegime -> reportingRegime.getCftcPartyInformation()).map("getIsUSPerson", cFTCPartyInformation -> cFTCPartyInformation.getIsUSPerson());
        }
    }
}

