/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.emir.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.PositionForEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.emir.functions.IsMicXOFF;
import drr.regulation.common.emir.functions.IsMicXXXX;
import drr.regulation.common.functions.GetReportTrackingNumber;
import drr.regulation.common.functions.GetVenueOfExecution;
import javax.inject.Inject;

@ImplementedBy(value=ReportTrackingNumberRuleDefault.class)
public abstract class ReportTrackingNumberRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected GetReportTrackingNumber getReportTrackingNumber;
    @Inject
    protected GetVenueOfExecution getVenueOfExecution;
    @Inject
    protected IsMicXOFF isMicXOFF;
    @Inject
    protected IsMicXXXX isMicXXXX;
    @Inject
    protected PositionForEvent positionForEvent;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class ReportTrackingNumberRuleDefault
    extends ReportTrackingNumberRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            output = (String)MapperS.of((Object)input).mapSingleToItem(item -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.getVenueOfExecution.evaluate((ReportableInformation)item.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)this.positionForEvent.evaluate((ReportableEventBase)item.get())))).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isMicXOFF.evaluate((TransactionReportInstruction)item.get())), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isMicXXXX.evaluate((TransactionReportInstruction)item.get())), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.getReportTrackingNumber.evaluate((ReportableEventBase)item.get()));
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

