/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.trade.quantity.QuantityFrequency;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=AdjustFrequencyPeriodDefault.class)
public abstract class AdjustFrequencyPeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public QuantityFrequency evaluate(FrequencyPeriodEnum period, BigDecimal periodMultiplier) {
        QuantityFrequency periodValues;
        QuantityFrequency.QuantityFrequencyBuilder periodValuesBuilder = this.doEvaluate(period, periodMultiplier);
        if (periodValuesBuilder == null) {
            periodValues = null;
        } else {
            periodValues = periodValuesBuilder.build();
            this.objectValidator.validate(QuantityFrequency.class, (RosettaModelObject)periodValues);
        }
        return periodValues;
    }

    protected abstract QuantityFrequency.QuantityFrequencyBuilder doEvaluate(FrequencyPeriodEnum var1, BigDecimal var2);

    public static class AdjustFrequencyPeriodDefault
    extends AdjustFrequencyPeriod {
        @Override
        protected QuantityFrequency.QuantityFrequencyBuilder doEvaluate(FrequencyPeriodEnum period, BigDecimal periodMultiplier) {
            QuantityFrequency.QuantityFrequencyBuilder periodValues = QuantityFrequency.builder();
            return this.assignOutput(periodValues, period, periodMultiplier);
        }

        protected QuantityFrequency.QuantityFrequencyBuilder assignOutput(QuantityFrequency.QuantityFrequencyBuilder periodValues, FrequencyPeriodEnum period, BigDecimal periodMultiplier) {
            FrequencyPeriodEnum ifThenElseResult0 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)period)), (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.MNTH)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)periodMultiplier), (Mapper)MapperS.of((Object)BigDecimal.valueOf(12L)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? FrequencyPeriodEnum.YEAR : period;
            Integer ifThenElseResult1 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)period)), (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.MNTH)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)periodMultiplier), (Mapper)MapperS.of((Object)BigDecimal.valueOf(12L)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? Integer.valueOf(1) : (periodMultiplier == null ? null : Integer.valueOf(periodMultiplier.intValueExact()));
            periodValues = (QuantityFrequency.QuantityFrequencyBuilder)this.toBuilder(QuantityFrequency.builder().setPeriod(ifThenElseResult0).setPeriodMultiplier(ifThenElseResult1).build());
            return Optional.ofNullable(periodValues).map(o -> o.prune()).orElse(null);
        }
    }
}

