/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.datetime.Frequency;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;

@ImplementedBy(value=FrequencyPeriodMultiplierDefault.class)
public abstract class FrequencyPeriodMultiplier
implements RosettaFunction {
    public Integer evaluate(Frequency frequency) {
        Integer periodMultiplier = this.doEvaluate(frequency);
        return periodMultiplier;
    }

    protected abstract Integer doEvaluate(Frequency var1);

    public static class FrequencyPeriodMultiplierDefault
    extends FrequencyPeriodMultiplier {
        @Override
        protected Integer doEvaluate(Frequency frequency) {
            Integer periodMultiplier = null;
            return this.assignOutput(periodMultiplier, frequency);
        }

        protected Integer assignOutput(Integer periodMultiplier, Frequency frequency) {
            periodMultiplier = (Integer)MapperS.of((Object)frequency).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).get();
            return periodMultiplier;
        }
    }
}

