/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.datetime.functions.Today;
import cdm.event.common.Reset;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=GetLastFloatingReferenceValueDefault.class)
public abstract class GetLastFloatingReferenceValue
implements RosettaFunction {
    @Inject
    protected Today today;

    public BigDecimal evaluate(List<? extends Reset> resetHistory) {
        BigDecimal lastFloatingReferenceValue = this.doEvaluate(resetHistory);
        return lastFloatingReferenceValue;
    }

    protected abstract BigDecimal doEvaluate(List<? extends Reset> var1);

    public static class GetLastFloatingReferenceValueDefault
    extends GetLastFloatingReferenceValue {
        @Override
        protected BigDecimal doEvaluate(List<? extends Reset> resetHistory) {
            if (resetHistory == null) {
                resetHistory = Collections.emptyList();
            }
            BigDecimal lastFloatingReferenceValue = null;
            return this.assignOutput(lastFloatingReferenceValue, resetHistory);
        }

        protected BigDecimal assignOutput(BigDecimal lastFloatingReferenceValue, List<? extends Reset> resetHistory) {
            MapperC thenArg0 = MapperC.of(resetHistory).filterItemNullSafe(item -> ExpressionOperators.lessThanEquals((Mapper)item.map("getResetDate", reset -> reset.getResetDate()), (Mapper)MapperS.of((Object)this.today.evaluate()), (CardinalityOperator)CardinalityOperator.All).get());
            MapperS thenArg1 = thenArg0.max(item -> item.map("getResetDate", reset -> reset.getResetDate()));
            lastFloatingReferenceValue = (BigDecimal)thenArg1.map("getResetValue", reset -> reset.getResetValue()).map("getValue", price -> price.getValue()).get();
            return lastFloatingReferenceValue;
        }
    }
}

